/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.variant.BlockKind;
import juuxel.adorn.block.variant.BlockVariantSets;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.platform.forge.block.entity.BlockEntityWithFluidTank;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public final class AdornCapabilities {
    private static final IBlockCapabilityProvider<IItemHandler, @Nullable Direction> INVENTORY_WRAPPER_FOR_BLOCK = (world, pos, state, blockEntity, side) -> {
        IItemHandler iItemHandler;
        if (blockEntity instanceof Container) {
            Container inventory = (Container)blockEntity;
            iItemHandler = AdornCapabilities.getInventoryWrapper(inventory, side);
        } else {
            iItemHandler = null;
        }
        return iItemHandler;
    };
    private static final ICapabilityProvider<BlockEntity, @Nullable Direction, IItemHandler> INVENTORY_WRAPPER_FOR_BLOCK_ENTITY = (blockEntity, side) -> {
        IItemHandler iItemHandler;
        if (blockEntity instanceof Container) {
            Container inventory = (Container)blockEntity;
            iItemHandler = AdornCapabilities.getInventoryWrapper(inventory, side);
        } else {
            iItemHandler = null;
        }
        return iItemHandler;
    };
    private static final IBlockCapabilityProvider<IFluidHandler, @Nullable Direction> FLUID_TANK_FOR_BLOCK = (world, pos, state, blockEntity, side) -> {
        FluidTank fluidTank;
        if (blockEntity instanceof BlockEntityWithFluidTank) {
            BlockEntityWithFluidTank withTank = (BlockEntityWithFluidTank)blockEntity;
            fluidTank = withTank.getTank();
        } else {
            fluidTank = null;
        }
        return fluidTank;
    };
    private static final ICapabilityProvider<BlockEntity, @Nullable Direction, IFluidHandler> FLUID_TANK_FOR_BLOCK_ENTITY = (blockEntity, side) -> {
        FluidTank fluidTank;
        if (blockEntity instanceof BlockEntityWithFluidTank) {
            BlockEntityWithFluidTank withTank = (BlockEntityWithFluidTank)blockEntity;
            fluidTank = withTank.getTank();
        } else {
            fluidTank = null;
        }
        return fluidTank;
    };

    public static void register(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)AdornBlockEntities.BREWER.get(), INVENTORY_WRAPPER_FOR_BLOCK_ENTITY);
        BlockKind[] containerBlockKinds = new BlockKind[]{BlockKind.DRAWER, BlockKind.KITCHEN_CUPBOARD, BlockKind.SHELF};
        for (BlockKind kind : containerBlockKinds) {
            for (Registered<Block> block : BlockVariantSets.get(kind)) {
                event.registerBlock(Capabilities.ItemHandler.BLOCK, INVENTORY_WRAPPER_FOR_BLOCK, new Block[]{(Block)block.get()});
            }
        }
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AdornBlockEntities.BREWER.get(), FLUID_TANK_FOR_BLOCK_ENTITY);
        for (Registered registered : BlockVariantSets.get(BlockKind.KITCHEN_SINK)) {
            event.registerBlock(Capabilities.FluidHandler.BLOCK, FLUID_TANK_FOR_BLOCK, new Block[]{(Block)registered.get()});
        }
    }

    private static IItemHandler getInventoryWrapper(Container inventory, @Nullable Direction side) {
        InvWrapper invWrapper;
        if (side != null && inventory instanceof WorldlyContainer) {
            WorldlyContainer sided = (WorldlyContainer)inventory;
            invWrapper = new SidedInvWrapper(sided, side);
        } else {
            invWrapper = new InvWrapper(inventory);
        }
        return invWrapper;
    }
}

