/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.AdornBlockSetTypes;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.AdornWoodTypes;
import juuxel.adorn.block.variant.BlockVariantSets;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.entity.AdornEntities;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.item.group.AdornItemGroups;
import juuxel.adorn.lib.AdornGameRules;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.lib.AdornTags;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.loot.AdornLootConditionTypes;
import juuxel.adorn.loot.AdornLootFunctionTypes;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.platform.forge.AdornCapabilities;
import juuxel.adorn.platform.forge.client.AdornClient;
import juuxel.adorn.platform.forge.compat.Compat;
import juuxel.adorn.platform.forge.event.BlockEvents;
import juuxel.adorn.platform.forge.event.EntityEvents;
import juuxel.adorn.platform.forge.event.ItemEvents;
import juuxel.adorn.platform.forge.networking.AdornNetworking;
import juuxel.adorn.platform.forge.registrar.ForgeRegistrar;
import juuxel.adorn.recipe.AdornRecipeSerializers;
import juuxel.adorn.recipe.AdornRecipeTypes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;

@Mod(value="adorn")
public final class Adorn {
    public Adorn() {
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        ConfigManager.get().init();
        modBus.addListener(this::init);
        this.register(AdornComponentTypes.DATA_COMPONENT_TYPES, modBus);
        this.register(AdornSounds.SOUNDS, modBus);
        AdornBlockSetTypes.init();
        AdornWoodTypes.init();
        this.register(AdornBlocks.BLOCKS, modBus);
        this.register(AdornBlocks.ITEMS, modBus);
        this.register(AdornItems.ITEMS, modBus);
        this.register(AdornEntities.ENTITIES, modBus);
        this.register(AdornBlockEntities.BLOCK_ENTITIES, modBus);
        AdornItemGroups.init();
        this.register(AdornItemGroups.ITEM_GROUPS, modBus);
        AdornRecipeTypes.init();
        AdornRecipeSerializers.init();
        this.register(AdornMenus.MENUS, modBus);
        this.register(AdornRecipeSerializers.RECIPE_SERIALIZERS, modBus);
        this.register(AdornRecipeTypes.RECIPE_TYPES, modBus);
        this.register(AdornLootConditionTypes.LOOT_CONDITION_TYPES, modBus);
        this.register(AdornLootFunctionTypes.LOOT_FUNCTION_TYPES, modBus);
        this.register(AdornStats.CUSTOM_STATS, modBus);
        modBus.addListener(AdornNetworking::register);
        AdornCriteria.init();
        this.register(AdornCriteria.CRITERIA, modBus);
        ItemEvents.register(modBus);
        BlockEvents.init();
        EntityEvents.init();
        modBus.addListener(AdornCapabilities::register);
        Compat.init(modBus);
        BlockVariantSets.register();
        NeoForgeMod.enableMilkFluid();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AdornClient.init(modBus);
        }
    }

    private void register(Registrar<?> registrar, IEventBus modBus) {
        ((ForgeRegistrar)registrar).hook(modBus);
    }

    private void init(FMLCommonSetupEvent event) {
        AdornGameRules.init();
        AdornTags.init();
        AdornStats.init();
        ConfigManager.get().finish();
    }
}

