/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform;

import juuxel.adorn.block.SofaBlock;
import juuxel.adorn.block.variant.BlockVariant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;

public interface BlockFactory {
    public static final BlockFactory DEFAULT = new BlockFactory(){};

    default public SofaBlock createSofa(BlockVariant variant) {
        return new SofaBlock(variant);
    }

    default public Block createPaintedPlanks(BlockBehaviour.Properties settings) {
        return new Block(settings);
    }

    default public Block createPaintedWoodSlab(BlockBehaviour.Properties settings) {
        return new SlabBlock(settings);
    }

    default public Block createPaintedWoodStairs(BlockState baseBlockState, BlockBehaviour.Properties settings) {
        return new StairBlock(baseBlockState, settings);
    }

    default public Block createPaintedWoodFence(BlockBehaviour.Properties settings) {
        return new FenceBlock(settings);
    }

    default public Block createPaintedWoodFenceGate(WoodType woodType, BlockBehaviour.Properties settings) {
        return new FenceGateBlock(woodType, settings);
    }
}

