/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.entity.TradingStation;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.trading.TradeInventory;
import juuxel.adorn.util.InventoryComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class TradingStationMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final TradingStation tradingStation;
    private final Slot sellingSlot;
    private final Slot priceSlot;

    public TradingStationMenu(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super((MenuType)AdornMenus.TRADING_STATION.get(), syncId);
        int x;
        int y;
        this.context = context;
        int slot = 18;
        this.tradingStation = TradingStationMenu.getTradingStation(context);
        TradeInventory tradeInventory = this.tradingStation.getTrade().createInventory();
        InventoryComponent storage = this.tradingStation.getStorage();
        this.sellingSlot = this.addSlot(new TradeSlot(tradeInventory, 0, 26, 36));
        this.priceSlot = this.addSlot(new TradeSlot(tradeInventory, 1, 26, 72));
        for (y = 0; y <= 2; ++y) {
            for (x = 0; x <= 3; ++x) {
                this.addSlot(new StorageSlot(storage, x + y * 4, 62 + x * slot, 36 + y * slot));
            }
        }
        for (y = 0; y <= 2; ++y) {
            for (x = 0; x <= 8; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * slot, 104 + y * slot));
            }
        }
        for (int x2 = 0; x2 <= 8; ++x2) {
            this.addSlot(new Slot((Container)playerInventory, x2, 8 + x2 * slot, 162));
        }
    }

    public TradingStationMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    private static TradingStation getTradingStation(ContainerLevelAccess context) {
        return context.evaluate((world, pos) -> world.getBlockEntity(pos, (BlockEntityType)AdornBlockEntities.TRADING_STATION.get())).flatMap(tradingStation -> tradingStation).orElseGet(TradingStation::createEmpty);
    }

    public static boolean isValidItem(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    public Slot getSellingSlot() {
        return this.sellingSlot;
    }

    public Slot getPriceSlot() {
        return this.priceSlot;
    }

    public boolean stillValid(Player player) {
        return TradingStationMenu.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)AdornBlocks.TRADING_STATION.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int offset = 2;
        if (index < offset) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int containerSize = 12;
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (offset <= index && index < containerSize + offset ? !this.moveItemStackTo(stack, containerSize + offset, this.slots.size(), true) : !this.moveItemStackTo(stack, offset, containerSize + offset, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        Slot slot;
        Slot slot2 = slot = 0 <= slotIndex && slotIndex < this.slots.size() ? (Slot)this.slots.get(slotIndex) : null;
        if (actionType == ClickType.PICKUP && slot instanceof TradeSlot) {
            TradeSlot tradeSlot = (TradeSlot)slot;
            ItemStack cursorStack = this.getCarried();
            if (TradingStationMenu.isValidItem(cursorStack)) {
                this.updateTradeStack(tradeSlot, cursorStack.copy(), player);
            }
        } else {
            super.clicked(slotIndex, button, actionType, player);
        }
    }

    public void updateTradeStack(int slotId, ItemStack stack, Player player) {
        Slot slot = this.getSlot(slotId);
        if (slot instanceof TradeSlot) {
            TradeSlot slot2 = (TradeSlot)slot;
            this.updateTradeStack(slot2, stack, player);
        }
    }

    private void updateTradeStack(TradeSlot slot, ItemStack stack, Player player) {
        slot.setByPlayer(stack);
        slot.setChanged();
        TradingStation tradingStation = this.tradingStation;
        if (tradingStation instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)tradingStation;
            BlockState state = be.getBlockState();
            player.level().sendBlockUpdated(be.getBlockPos(), state, state, 2);
        }
    }

    private static final class TradeSlot
    extends Slot {
        private TradeSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPickup(Player playerEntity) {
            return false;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public ItemStack remove(int amount) {
            return ItemStack.EMPTY;
        }
    }

    private static final class StorageSlot
    extends Slot {
        private StorageSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return TradingStationMenu.isValidItem(stack);
        }
    }
}

