/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.menu.ContainerBlockMenu;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class SimpleMenu
extends AbstractContainerMenu
implements ContainerBlockMenu {
    private final int width;
    private final int height;
    private final Container inventory;
    private final ContainerLevelAccess context;

    public SimpleMenu(MenuType<?> type, int syncId, int width, int height, Container inventory, Inventory playerInventory, ContainerLevelAccess context) {
        super(type, syncId);
        int x;
        int y;
        this.width = width;
        this.height = height;
        this.inventory = inventory;
        this.context = context;
        int offset = (9 - width) / 2;
        SimpleMenu.checkContainerSize((Container)inventory, (int)(width * height));
        int slot = 18;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                this.addSlot(new Slot(inventory, y * width + x, 8 + (x + offset) * slot, 17 + y * slot));
            }
        }
        for (y = 0; y <= 2; ++y) {
            for (x = 0; x <= 8; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * slot, 84 + y * slot));
            }
        }
        for (int x2 = 0; x2 <= 8; ++x2) {
            this.addSlot(new Slot((Container)playerInventory, x2, 8 + x2 * slot, 142));
        }
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public ContainerLevelAccess getContext() {
        return this.context;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int containerSize = this.width * this.height;
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (index < containerSize ? !this.moveItemStackTo(stack, containerSize, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, containerSize, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }
}

