/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.networking.BrewerFluidSyncS2CMessage;
import juuxel.adorn.platform.PlatformBridges;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class BrewerMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData propertyDelegate;
    private FluidReference fluid;
    private final Player player;
    @Nullable
    private FluidVolume lastFluid = null;

    public BrewerMenu(int syncId, Inventory playerInventory, Container container, ContainerData propertyDelegate, FluidReference fluid) {
        super((MenuType)AdornMenus.BREWER.get(), syncId);
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.fluid = fluid;
        this.player = playerInventory.player;
        BrewerMenu.checkContainerSize((Container)container, (int)4);
        BrewerMenu.checkContainerDataCount((ContainerData)propertyDelegate, (int)1);
        this.addSlot(new MainSlot(container, 0, 80, 56));
        this.addSlot(new Slot(container, 1, 50, 17));
        this.addSlot(new Slot(container, 2, 110, 17));
        this.addSlot(new FluidContainerSlot(container, 3, 123, 60));
        for (int y = 0; y <= 2; ++y) {
            for (int x = 0; x <= 8; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x <= 8; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, 142));
        }
        this.addDataSlots(propertyDelegate);
    }

    public BrewerMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(1), FluidVolume.empty(FluidUnit.LITRE));
    }

    public int getProgress() {
        return this.propertyDelegate.get(0);
    }

    public FluidReference getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidReference fluid) {
        this.fluid = fluid;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (index <= 3) {
                if (!this.moveItemStackTo(stack, 4, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Slot mugSlot = (Slot)this.slots.get(0);
                if (!mugSlot.hasItem() && mugSlot.mayPlace(stack)) {
                    mugSlot.setByPlayer(stack.split(Math.min(mugSlot.getMaxStackSize(stack), stack.getCount())));
                }
                if (!stack.isEmpty() && !this.moveItemStackTo(stack, 1, 4, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        FluidVolume last = this.lastFluid;
        if (last == null || !FluidReference.areFluidsAndAmountsEqual(this.fluid, last)) {
            this.lastFluid = this.fluid.createSnapshot();
            PlatformBridges.get().getNetwork().sendToClient(this.player, new BrewerFluidSyncS2CMessage(this.containerId, this.fluid.createSnapshot()));
        }
    }

    private static final class MainSlot
    extends Slot {
        private MainSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is((Item)AdornItems.MUG.get());
        }
    }

    private static final class FluidContainerSlot
    extends Slot {
        private FluidContainerSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

