/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.menu.DrawerMenu;
import juuxel.adorn.menu.KitchenCupboardMenu;
import juuxel.adorn.menu.TradingStationMenu;
import juuxel.adorn.platform.MenuBridge;
import juuxel.adorn.platform.PlatformBridges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public final class AdornMenus {
    public static final Registrar<MenuType<?>> MENUS = RegistrarFactory.get().create(Registries.MENU);
    public static final Registered<MenuType<DrawerMenu>> DRAWER = MENUS.register("drawer", () -> AdornMenus.createType(DrawerMenu::load));
    public static final Registered<MenuType<KitchenCupboardMenu>> KITCHEN_CUPBOARD = MENUS.register("kitchen_cupboard", () -> AdornMenus.createType(KitchenCupboardMenu::load));
    public static final Registered<MenuType<TradingStationMenu>> TRADING_STATION = MENUS.register("trading_station", () -> new MenuType(TradingStationMenu::new, FeatureFlags.VANILLA_SET));
    public static final Registered<MenuType<BrewerMenu>> BREWER = MENUS.register("brewer", () -> new MenuType(BrewerMenu::new, FeatureFlags.VANILLA_SET));

    public static void init() {
    }

    private static <M extends AbstractContainerMenu> MenuType<M> createType(MenuBridge.Factory<M, BlockPos> factory) {
        return PlatformBridges.get().getMenus().createType(factory, BlockPos.STREAM_CODEC);
    }
}

