/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import juuxel.adorn.loot.AdornLootConditionTypes;
import juuxel.adorn.util.Logging;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.slf4j.Logger;

public record GameRuleLootCondition(GameRules.Key<?> gameRule) implements LootItemCondition
{
    public static final MapCodec<GameRuleLootCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.xmap(name -> new GameRules.Key(name, GameRules.Category.MISC), GameRules.Key::getId).fieldOf("game_rule").forGetter(GameRuleLootCondition::gameRule)).apply((Applicative)builder, GameRuleLootCondition::new));
    private static final Logger LOGGER = Logging.logger();

    public boolean test(LootContext lootContext) {
        GameRules.Value rule = lootContext.getLevel().getGameRules().getRule(this.gameRule);
        if (rule instanceof GameRules.BooleanValue) {
            GameRules.BooleanValue booleanRule = (GameRules.BooleanValue)rule;
            return booleanRule.get();
        }
        if (rule == null) {
            LOGGER.error("Unknown game rule {} in loot condition", this.gameRule);
        } else {
            LOGGER.error("Game rule {} ({}) is not a boolean", (Object)rule, this.gameRule);
        }
        return false;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)AdornLootConditionTypes.GAME_RULE.get();
    }
}

