/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib.registry;

import java.util.function.Function;
import java.util.function.Supplier;
import juuxel.adorn.item.BaseBlockItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class RegistryHelper {
    private final Registrar<Block> blocks;
    private final Registrar<Item> items;

    public RegistryHelper(Registrar<Block> blocks, Registrar<Item> items) {
        this.blocks = blocks;
        this.items = items;
    }

    public <T extends Block> Registered<T> registerBlock(String name, Supplier<T> block) {
        return this.registerBlock(name, Item.Properties::new, block);
    }

    public <T extends Block> Registered<T> registerBlock(String name, Supplier<Item.Properties> itemSettings, Supplier<T> block) {
        return this.registerBlock(name, (T b) -> this.makeItemForBlock((Block)b, (Item.Properties)itemSettings.get()), block);
    }

    public <T extends Block> Registered<T> registerBlock(String name, Function<T, Item> itemProvider, Supplier<T> block) {
        Registered registered = this.registerBlockWithoutItem(name, block);
        this.registerItem(name, () -> (Item)itemProvider.apply((Block)registered.get()));
        return registered;
    }

    public <T extends Block> Registered<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return this.blocks.register(name, block);
    }

    private Item makeItemForBlock(Block block, Item.Properties itemSettings) {
        return new BaseBlockItem(block, itemSettings);
    }

    public <T extends Item> Registered<T> registerItem(String name, Supplier<T> content) {
        return this.items.register(name, content);
    }
}

