/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib;

import java.util.function.Supplier;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;

public final class AdornSounds {
    public static final Registrar<SoundEvent> SOUNDS = RegistrarFactory.get().create(Registries.SOUND_EVENT);
    public static final Registered<SoundEvent> BLOCK_CHAIN_LINK_FENCE_BREAK = AdornSounds.register("block.adorn.chain_link_fence.break");
    public static final Registered<SoundEvent> BLOCK_CHAIN_LINK_FENCE_STEP = AdornSounds.register("block.adorn.chain_link_fence.step");
    public static final Registered<SoundEvent> BLOCK_CHAIN_LINK_FENCE_PLACE = AdornSounds.register("block.adorn.chain_link_fence.place");
    public static final Registered<SoundEvent> BLOCK_CHAIN_LINK_FENCE_HIT = AdornSounds.register("block.adorn.chain_link_fence.hit");
    public static final Registered<SoundEvent> BLOCK_CHAIN_LINK_FENCE_FALL = AdornSounds.register("block.adorn.chain_link_fence.fall");
    public static final Registered<SoundEvent> ITEM_WATERING_CAN_WATER = AdornSounds.register("item.adorn.watering_can.water");
    public static final SoundType CHAIN_LINK_FENCE = new LazyBlockSoundGroup(1.0f, 1.5f, BLOCK_CHAIN_LINK_FENCE_BREAK, BLOCK_CHAIN_LINK_FENCE_STEP, BLOCK_CHAIN_LINK_FENCE_PLACE, BLOCK_CHAIN_LINK_FENCE_HIT, BLOCK_CHAIN_LINK_FENCE_FALL);

    public static void init() {
    }

    private static Registered<SoundEvent> register(String name) {
        return SOUNDS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)AdornCommon.id(name)));
    }

    private static final class LazyBlockSoundGroup
    extends SoundType {
        private final Supplier<SoundEvent> breakSound;
        private final Supplier<SoundEvent> stepSound;
        private final Supplier<SoundEvent> placeSound;
        private final Supplier<SoundEvent> hitSound;
        private final Supplier<SoundEvent> fallSound;

        LazyBlockSoundGroup(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
            super(volume, pitch, null, null, null, null, null);
            this.breakSound = breakSound;
            this.stepSound = stepSound;
            this.placeSound = placeSound;
            this.hitSound = hitSound;
            this.fallSound = fallSound;
        }

        public SoundEvent getBreakSound() {
            return this.breakSound.get();
        }

        public SoundEvent getStepSound() {
            return this.stepSound.get();
        }

        public SoundEvent getPlaceSound() {
            return this.placeSound.get();
        }

        public SoundEvent getHitSound() {
            return this.hitSound.get();
        }

        public SoundEvent getFallSound() {
            return this.fallSound.get();
        }
    }
}

