/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib;

import java.util.function.Predicate;
import juuxel.adorn.config.Config;
import juuxel.adorn.config.ConfigManager;
import net.minecraft.world.level.GameRules;

public final class AdornGameRules {
    public static final GameRules.Key<GameRules.BooleanValue> SKIP_NIGHT_ON_SOFAS = AdornGameRules.register("skipNightOnSofas", GameRules.Category.PLAYER, AdornGameRules.createBooleanRule(defaults -> defaults.skipNightOnSofas));
    public static final GameRules.Key<GameRules.BooleanValue> INFINITE_KITCHEN_SINKS = AdornGameRules.register("infiniteKitchenSinks", GameRules.Category.MISC, AdornGameRules.createBooleanRule(defaults -> defaults.infiniteKitchenSinks));
    public static final GameRules.Key<GameRules.BooleanValue> DROP_LOCKED_TRADING_STATIONS = AdornGameRules.register("dropLockedTradingStations", GameRules.Category.DROPS, AdornGameRules.createBooleanRule(defaults -> defaults.dropLockedTradingStations));

    public static void init() {
    }

    private static GameRules.Type<GameRules.BooleanValue> createBooleanRule(Predicate<Config.GameRuleDefaults> defaultGetter) {
        return GameRules.BooleanValue.create((boolean)defaultGetter.test(ConfigManager.config().gameRuleDefaults));
    }

    private static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> type) {
        return GameRules.register((String)("adorn:" + name), (GameRules.Category)category, type);
    }
}

