/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import juuxel.adorn.fluid.FluidKey;
import juuxel.adorn.util.EntryOrTag;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

final class FluidKeyImpl {
    private static final Codec<Simple> SIMPLE_CODEC = EntryOrTag.codec(Registries.FLUID).xmap(Simple::new, Simple::fluids);
    public static final Codec<FluidKey> CODEC = Codec.either(SIMPLE_CODEC, (Codec)SIMPLE_CODEC.listOf().xmap(OfArray::new, OfArray::children)).xmap(Either::unwrap, key -> {
        FluidKey fluidKey = key;
        Objects.requireNonNull(fluidKey);
        FluidKey selector0$temp = fluidKey;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Simple.class, OfArray.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Simple simple = (Simple)selector0$temp;
                yield Either.left((Object)simple);
            }
            case 1 -> {
                OfArray ofArray = (OfArray)selector0$temp;
                yield Either.right((Object)ofArray);
            }
        };
    });

    FluidKeyImpl() {
    }

    record Simple(EntryOrTag<Fluid> fluids) implements FluidKey
    {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Fluid> getFluids() {
            Set<Object> set;
            EntryOrTag<Fluid> entryOrTag = this.fluids;
            Objects.requireNonNull(entryOrTag);
            EntryOrTag<Fluid> entryOrTag2 = entryOrTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryOrTag.OfEntry.class, EntryOrTag.OfTag.class}, entryOrTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Fluid fluid2;
                    EntryOrTag.OfEntry ofEntry = (EntryOrTag.OfEntry)entryOrTag2;
                    try {
                        Fluid fluid;
                        fluid2 = fluid = (Fluid)ofEntry.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    set = Set.of(fluid2);
                    return set;
                }
                case 1: 
            }
            EntryOrTag.OfTag ofTag = (EntryOrTag.OfTag)entryOrTag2;
            {
                TagKey tagKey;
                TagKey tag = tagKey = ofTag.tag();
                set = BuiltInRegistries.FLUID.getOrCreateTag(tag).stream().map(Holder::value).collect(Collectors.toSet());
            }
            return set;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matches(Fluid fluid) {
            TagKey tag;
            boolean bl;
            EntryOrTag<Fluid> entryOrTag = this.fluids;
            Objects.requireNonNull(entryOrTag);
            EntryOrTag<Fluid> entryOrTag2 = entryOrTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryOrTag.OfEntry.class, EntryOrTag.OfTag.class}, entryOrTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Fluid keyFluid;
                    EntryOrTag.OfEntry ofEntry = (EntryOrTag.OfEntry)entryOrTag2;
                    try {
                        Fluid fluid2;
                        keyFluid = fluid2 = (Fluid)ofEntry.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    bl = fluid.isSame(keyFluid);
                    return bl;
                }
                case 1: 
            }
            EntryOrTag.OfTag ofTag = (EntryOrTag.OfTag)entryOrTag2;
            {
                TagKey tagKey;
                tag = tagKey = ofTag.tag();
            }
            bl = fluid.is(tag);
            return bl;
        }
    }

    record OfArray(List<Simple> children) implements FluidKey
    {
        @Override
        public Set<Fluid> getFluids() {
            return this.children.stream().flatMap(child -> child.getFluids().stream()).collect(Collectors.toSet());
        }

        @Override
        public boolean matches(Fluid fluid) {
            for (Simple child : this.children) {
                if (!child.matches(fluid)) continue;
                return true;
            }
            return false;
        }
    }
}

