/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import juuxel.adorn.fluid.FluidKey;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.HasFluidAmount;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record FluidIngredient(FluidKey fluid, long amount, DataComponentPatch components, FluidUnit unit) implements HasFluidAmount
{
    public static final Codec<FluidIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidKey.CODEC.fieldOf("fluid").forGetter(FluidIngredient::fluid), (App)Codec.LONG.fieldOf("amount").forGetter(FluidIngredient::amount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(FluidIngredient::components), (App)FluidUnit.CODEC.optionalFieldOf("unit", (Object)FluidUnit.LITRE).forGetter(FluidIngredient::unit)).apply((Applicative)instance, FluidIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredient> PACKET_CODEC = StreamCodec.ofMember(FluidIngredient::write, FluidIngredient::load);

    private static FluidIngredient load(RegistryFriendlyByteBuf buf) {
        FluidKey fluid = FluidKey.load((FriendlyByteBuf)buf);
        long amount = buf.readVarLong();
        DataComponentPatch components = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
        FluidUnit unit = (FluidUnit)buf.readEnum(FluidUnit.class);
        return new FluidIngredient(fluid, amount, components, unit);
    }

    private void write(RegistryFriendlyByteBuf buf) {
        this.fluid.write((FriendlyByteBuf)buf);
        buf.writeVarLong(this.amount);
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.components);
        buf.writeEnum((Enum)this.unit);
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public FluidUnit getUnit() {
        return this.unit;
    }
}

