/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.rei.client;

import com.mojang.datafixers.util.Pair;
import java.util.stream.Stream;
import juuxel.adorn.client.gui.screen.TradingStationScreen;
import juuxel.adorn.menu.TradingStationMenu;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class TradingStationDraggableStackVisitor
implements DraggableStackVisitor<TradingStationScreen> {
    private Stream<Pair<Slot, Rectangle>> slots(DraggingContext<TradingStationScreen> context) {
        TradingStationMenu menu = (TradingStationMenu)((TradingStationScreen)context.getScreen()).getMenu();
        return Stream.of(menu.getSellingSlot(), menu.getPriceSlot()).map(slot -> Pair.of((Object)slot, (Object)new Rectangle(slot.x, slot.y, 16, 16))).peek(pair -> ((Rectangle)pair.getSecond()).translate(((TradingStationScreen)context.getScreen()).getPanelX(), ((TradingStationScreen)context.getScreen()).getPanelY()));
    }

    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof TradingStationScreen;
    }

    private static boolean isValidStack(DraggableStack stack) {
        EntryStack entryStack = stack.getStack();
        if (!entryStack.getType().equals((Object)VanillaEntryTypes.ITEM)) {
            return false;
        }
        ItemStack itemStack = (ItemStack)entryStack.castValue();
        return TradingStationMenu.isValidItem(itemStack);
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<TradingStationScreen> context, DraggableStack stack) {
        if (!TradingStationDraggableStackVisitor.isValidStack(stack)) {
            return DraggedAcceptorResult.PASS;
        }
        Point pos = context.getCurrentPosition();
        if (pos == null) {
            return DraggedAcceptorResult.PASS;
        }
        Slot slot = this.slots(context).filter(pair -> ((Rectangle)pair.getSecond()).contains(pos)).findAny().map(Pair::getFirst).orElse(null);
        if (slot != null) {
            ((TradingStationScreen)context.getScreen()).updateTradeStack(slot, (ItemStack)stack.getStack().castValue());
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<TradingStationScreen> context, DraggableStack stack) {
        if (!TradingStationDraggableStackVisitor.isValidStack(stack)) {
            return Stream.empty();
        }
        return this.slots(context).map(Pair::getSecond).map(DraggableStackVisitor.BoundsProvider::ofRectangle);
    }
}

