/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.rei.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.compat.rei.AdornReiServer;
import juuxel.adorn.compat.rei.BrewerDisplay;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public final class BrewerCategory
implements DisplayCategory<BrewerDisplay> {
    private static final int FLUID_SCALE_Z_OFFSET = 100;
    private static final ResourceLocation LIGHT_TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png");
    private static final ResourceLocation DARK_TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_dark.png");

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)AdornBlocks.BREWER.get()));
    }

    public Component getTitle() {
        return Component.translatable((String)"category.adorn.brewer");
    }

    public CategoryIdentifier<? extends BrewerDisplay> getCategoryIdentifier() {
        return AdornReiServer.BREWER;
    }

    public int getDisplayHeight() {
        return 72;
    }

    public List<Widget> setupDisplay(BrewerDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Point topLeft = new Point(bounds.getCenterX() - 39, bounds.getCenterY() - 30);
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((context, _0, _1, _2) -> {
            context.blit(BrewerCategory.currentTexture(), topLeft.x, topLeft.y, 49, 16, 105, 61);
            float progressFraction = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int height = Math.round(progressFraction * 25.0f);
            context.blit(BrewerCategory.currentTexture(), topLeft.x + 35, topLeft.y + 8, 176, 0, 8, height);
        }));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(topLeft.x + 1, topLeft.y + 1)).disableBackground().markInput().entries((Collection)display.first()));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(topLeft.x + 61, topLeft.y + 1)).disableBackground().markInput().entries((Collection)display.second()));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(topLeft.x + 31, topLeft.y + 40)).disableBackground().markOutput().entry(display.result()));
        widgets.add((Widget)Widgets.createSlot((Rectangle)new Rectangle(topLeft.x + 87, topLeft.y, 18, 61)).disableBackground().markInput().entries((Collection)display.fluid()));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(topLeft.x + 4, topLeft.y + 39)).disableBackground().markInput().entries((Collection)display.input()));
        widgets.add(Widgets.createDrawableWidget((context, _0, _1, _2) -> {
            context.pose().pushPose();
            context.pose().translate(0.0f, 0.0f, 100.0f);
            context.blit(BrewerCategory.currentTexture(), topLeft.x + 88, topLeft.y + 1, 154, 17, 16, 59);
            context.pose().popPose();
        }));
        return widgets;
    }

    private static ResourceLocation currentTexture() {
        return REIRuntime.getInstance().isDarkThemeEnabled() ? DARK_TEXTURE : LIGHT_TEXTURE;
    }
}

