/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.jei;

import java.util.Iterator;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.compat.jei.JeiRecipeTypes;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public final class BrewerCategory
implements IRecipeCategory<BrewingRecipe> {
    private static final ResourceLocation TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png");
    private final IDrawable background = new Background();
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public BrewerCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.icon = this.guiHelper.createDrawableItemStack(((Block)AdornBlocks.BREWER.get()).asItem().getDefaultInstance());
    }

    public RecipeType<BrewingRecipe> getRecipeType() {
        return JeiRecipeTypes.BREWER;
    }

    public Component getTitle() {
        return Component.translatable((String)"category.adorn.brewer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, BrewingRecipe recipe, IFocusGroup focusGroup) {
        Object result;
        Object ingredient;
        Ingredient secondIngredient;
        Ingredient firstIngredient;
        int leftX = 0;
        int topY = 0;
        IRecipeSlotBuilder firstSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 1, topY + 1);
        IRecipeSlotBuilder secondSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 61, topY + 1);
        IRecipeSlotBuilder resultSlot = layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, leftX + 31, topY + 40);
        layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 4, topY + 39).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AdornItems.MUG.get()}));
        long capacity = FluidBridge.get().getFluidUnit().getBucketVolume() * 2L;
        IRecipeSlotBuilder tank = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 88, topY + 1).setFluidRenderer(capacity, false, 16, 59).setOverlay((IDrawable)this.guiHelper.createDrawable(TEXTURE, 154, 17, 16, 59), 0, 0);
        if (recipe instanceof ItemBrewingRecipe) {
            Ingredient result2;
            Ingredient secondIngredient2;
            Ingredient firstIngredient2;
            ItemBrewingRecipe itemBrewingRecipe = (ItemBrewingRecipe)recipe;
            try {
                Ingredient ingredient2;
                firstIngredient2 = ingredient2 = itemBrewingRecipe.firstIngredient();
                secondIngredient2 = ingredient2 = itemBrewingRecipe.secondIngredient();
                result2 = ingredient2 = itemBrewingRecipe.result();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            firstSlot.addIngredients(firstIngredient2);
            secondSlot.addIngredients(secondIngredient2);
            resultSlot.addItemStack((ItemStack)result2);
            return;
        }
        if (!(recipe instanceof FluidBrewingRecipe)) return;
        FluidBrewingRecipe fluidBrewingRecipe = (FluidBrewingRecipe)recipe;
        {
            Object object = fluidBrewingRecipe.firstIngredient();
            firstIngredient = object;
            object = fluidBrewingRecipe.secondIngredient();
            secondIngredient = object;
            ingredient = object = fluidBrewingRecipe.fluid();
            result = object = fluidBrewingRecipe.result();
        }
        firstSlot.addIngredients(firstIngredient);
        secondSlot.addIngredients(secondIngredient);
        resultSlot.addItemStack((ItemStack)result);
        long amount = FluidUnit.convert(((FluidIngredient)ingredient).getAmount(), ((FluidIngredient)ingredient).getUnit(), FluidBridge.get().getFluidUnit());
        Iterator<Fluid> iterator = ((FluidIngredient)ingredient).fluid().getFluids().iterator();
        while (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            tank.addFluidStack(fluid, amount, ((FluidIngredient)ingredient).components());
        }
    }

    private static final class Background
    implements IDrawable {
        private Background() {
        }

        public int getWidth() {
            return 105;
        }

        public int getHeight() {
            return 61;
        }

        public void draw(GuiGraphics context, int offsetX, int offsetY) {
            context.blit(TEXTURE, offsetX, offsetY, 49, 16, this.getWidth(), this.getHeight());
            float progressFraction = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int height = Math.round(progressFraction * 25.0f);
            context.blit(TEXTURE, offsetX + 35, offsetY + 8, 176, 0, 8, height);
        }
    }
}

