/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.jei;

import com.google.common.collect.Lists;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.client.gui.screen.TradingStationScreen;
import juuxel.adorn.compat.jei.BrewerCategory;
import juuxel.adorn.compat.jei.JeiRecipeTypes;
import juuxel.adorn.compat.jei.TradingStationGhostIngredientHandler;
import juuxel.adorn.recipe.AdornRecipeTypes;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;

@REIPluginCompatIgnore
@JeiPlugin
public final class AdornJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = AdornCommon.id("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BrewerCategory(registration.getJeiHelpers())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.registerRecipes(registration, (net.minecraft.world.item.crafting.RecipeType)AdornRecipeTypes.BREWING.get(), JeiRecipeTypes.BREWER);
    }

    private <I extends RecipeInput, T extends Recipe<I>> void registerRecipes(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> type, RecipeType<T> jeiType) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(jeiType, Lists.transform((List)manager.getAllRecipesFor(type), RecipeHolder::value));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)AdornBlocks.BREWER.get()).asItem().getDefaultInstance(), new RecipeType[]{JeiRecipeTypes.BREWER});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(TradingStationScreen.class, (IGhostIngredientHandler)new TradingStationGhostIngredientHandler());
    }
}

