/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.platform.ItemBridge;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public final class EmiUtil {
    public static EmiIngredient emiIngredientOf(FluidIngredient ingredient) {
        long amount = FluidUnit.convert(ingredient.amount(), ingredient.unit(), FluidBridge.get().getFluidUnit());
        return EmiIngredient.of(ingredient.fluid().getFluids().stream().map(fluid -> EmiStack.of((Fluid)fluid, (DataComponentPatch)ingredient.components(), (long)amount)).toList());
    }

    public static EmiIngredient withRemainders(EmiIngredient ingredient) {
        for (EmiStack stack : ingredient.getEmiStacks()) {
            ItemStack remainder;
            Item item = (Item)stack.getKeyOfType(Item.class);
            if (item == null || (remainder = ItemBridge.get().getRecipeRemainder(stack.getItemStack())).isEmpty()) continue;
            stack.setRemainder(EmiStack.of((ItemStack)remainder));
        }
        return ingredient;
    }
}

