/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.client.gui.screen.TradingStationScreen;
import juuxel.adorn.compat.emi.BrewingEmiRecipe;
import juuxel.adorn.compat.emi.TradingStationDragDropHandler;
import juuxel.adorn.recipe.AdornRecipeTypes;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public final class AdornEmiPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory BREWER_CATEGORY = new EmiRecipeCategory(AdornCommon.id("brewer"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AdornBlocks.BREWER.get())), (EmiRenderable)new EmiTexture(AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png"), 240, 0, 16, 16));

    public void register(EmiRegistry registry) {
        registry.addCategory(BREWER_CATEGORY);
        registry.addWorkstation(BREWER_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AdornBlocks.BREWER.get())));
        RecipeManager recipeManager = registry.getRecipeManager();
        for (RecipeHolder entry : recipeManager.getAllRecipesFor((RecipeType)AdornRecipeTypes.BREWING.get())) {
            BrewingRecipe brewingRecipe;
            Objects.requireNonNull((BrewingRecipe)entry.value());
            int n = 0;
            BrewingEmiRecipe emiRecipe = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemBrewingRecipe.class, FluidBrewingRecipe.class}, (Object)brewingRecipe, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ItemBrewingRecipe recipe = (ItemBrewingRecipe)brewingRecipe;
                    yield new BrewingEmiRecipe(entry.id(), recipe);
                }
                case 1 -> {
                    FluidBrewingRecipe recipe = (FluidBrewingRecipe)brewingRecipe;
                    yield new BrewingEmiRecipe(entry.id(), recipe);
                }
            };
            registry.addRecipe((EmiRecipe)emiRecipe);
        }
        registry.addDragDropHandler(TradingStationScreen.class, (EmiDragDropHandler)new TradingStationDragDropHandler());
    }
}

