/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.resources;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.resources.ColorPalette;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.Logging;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ColorManager
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonObject>>> {
    private static final Logger LOGGER = Logging.logger();
    private static final ResourceLocation FALLBACK = AdornCommon.id("fallback");
    private static final String PREFIX = "adorn/color_palettes";
    private static final Pattern COLOR_REGEX = Pattern.compile("^#(?:[0-9A-Fa-f]{2})?[0-9A-Fa-f]{6}$");
    private static final Codec<Map<ResourceLocation, ColorPair>> PALETTE_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, ColorPair.CODEC);
    private final Map<ResourceLocation, ColorPalette> palettes = new HashMap<ResourceLocation, ColorPalette>();

    protected Map<ResourceLocation, List<JsonObject>> prepare(ResourceManager manager, ProfilerFiller profiler) {
        Gson gson = new Gson();
        FileToIdConverter resourceFinder = FileToIdConverter.json((String)PREFIX);
        HashMap<ResourceLocation, List<JsonObject>> result = new HashMap<ResourceLocation, List<JsonObject>>();
        for (Map.Entry entry : resourceFinder.listMatchingResourceStacks(manager).entrySet()) {
            ResourceLocation id = resourceFinder.fileToId((ResourceLocation)entry.getKey());
            ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
            result.put(id, jsons);
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader in = resource.openAsReader();
                    try {
                        jsons.add((JsonObject)gson.fromJson((Reader)in, JsonObject.class));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("[Adorn] Could not load color palette resource {} from {}", new Object[]{entry.getKey(), resource.sourcePackId(), e});
                }
            }
        }
        return result;
    }

    protected void apply(Map<ResourceLocation, List<JsonObject>> prepared, ResourceManager manager, ProfilerFiller profiler) {
        this.palettes.clear();
        prepared.forEach((id, jsons) -> {
            HashMap<ResourceLocation, ColorPair> palette = new HashMap<ResourceLocation, ColorPair>();
            Iterator iterator = jsons.iterator();
            block7: while (true) {
                DataResult selector1$temp;
                if (!iterator.hasNext()) {
                    this.palettes.put((ResourceLocation)id, new ColorPalette(palette));
                    return;
                }
                JsonObject json = (JsonObject)iterator.next();
                Objects.requireNonNull(PALETTE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json));
                int index$2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector1$temp, index$2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Map partialPalette;
                        DataResult.Success $b$0 = (DataResult.Success)selector1$temp;
                        try {
                            Map patt3$temp;
                            partialPalette = patt3$temp = (Map)$b$0.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        {
                            Lifecycle patt4$temp;
                            Lifecycle lifecycle = patt4$temp = $b$0.lifecycle();
                            palette.putAll(partialPalette);
                            continue block7;
                        }
                    }
                    case 1: 
                }
                DataResult.Error error = (DataResult.Error)selector1$temp;
                LOGGER.error("[Adorn] Could not parse color palette {}: {}", id, (Object)error.message());
            }
        });
    }

    public ColorPalette getColors(ResourceLocation id) {
        ColorPalette pair = this.palettes.get(id);
        if (pair == null && (pair = this.palettes.get(FALLBACK)) == null) {
            throw new IllegalStateException("Could not find fallback palette!");
        }
        return pair;
    }

    private static DataResult<Integer> parseHexColor(String str) {
        if (!COLOR_REGEX.matcher(str).matches()) {
            return DataResult.error(() -> "Color must be a hex color beginning with '#' - found " + str);
        }
        String colorStr = str.substring(1);
        return DataResult.success((Object)(switch (colorStr.length()) {
            case 6 -> Colors.color(Integer.parseInt(colorStr, 16));
            case 8 -> Integer.parseInt(colorStr, 16);
            default -> throw new MatchException("Mismatching color length: " + colorStr.length(), null);
        }));
    }

    private static String writeHexColor(int color) {
        String hex = HexFormat.of().withUpperCase().toHexDigits(color);
        return "#" + (hex.startsWith("00") ? hex.substring(2) : hex);
    }

    public record ColorPair(int bg, int fg) {
        private static final int DEFAULT_FG = -12566464;
        private static final Codec<Integer> COLOR_CODEC = Codec.STRING.comapFlatMap(ColorManager::parseHexColor, ColorManager::writeHexColor);
        public static final Codec<ColorPair> CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)COLOR_CODEC.fieldOf("bg").forGetter(ColorPair::bg), (App)COLOR_CODEC.optionalFieldOf("fg", (Object)-12566464).forGetter(ColorPair::fg)).apply((Applicative)instance, ColorPair::new)), (Codec)COLOR_CODEC.xmap(bg -> new ColorPair((int)bg, -12566464), ColorPair::bg)).xmap(Either::unwrap, pair -> pair.fg == -12566464 ? Either.right((Object)pair) : Either.left((Object)pair));
    }
}

