/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import juuxel.adorn.block.ShelfBlock;
import juuxel.adorn.block.entity.ShelfBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.Property;

public final class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private static final float ITEM_SCALE = 0.5f;
    private static final float ITEM_1_Y_ROT = 10.0f;
    private static final float ITEM_2_Y_ROT = -17.0f;

    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShelfBlockEntity be, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Direction facing = (Direction)be.getBlockState().getValue((Property)ShelfBlock.FACING);
        double tx1 = switch (facing) {
            case Direction.SOUTH, Direction.WEST -> 0.75;
            default -> 0.25;
        };
        double tz1 = switch (facing) {
            case Direction.WEST, Direction.NORTH -> 0.75;
            default -> 0.25;
        };
        double tx2 = switch (facing) {
            case Direction.WEST, Direction.NORTH -> 0.75;
            default -> 0.25;
        };
        double tz2 = switch (facing) {
            case Direction.NORTH, Direction.EAST -> 0.75;
            default -> 0.25;
        };
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        matrices.pushPose();
        matrices.translate(tx1, 0.6, tz1);
        matrices.scale(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YP.rotationDegrees(190.0f - facing.toYRot()));
        itemRenderer.renderStatic(be.getItem(0), ItemDisplayContext.FIXED, light, overlay, matrices, vertexConsumers, be.getLevel(), 0);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(tx2, 0.6, tz2);
        matrices.scale(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YP.rotationDegrees(163.0f - facing.toYRot()));
        itemRenderer.renderStatic(be.getItem(1), ItemDisplayContext.FIXED, light, overlay, matrices, vertexConsumers, be.getLevel(), 0);
        matrices.popPose();
    }
}

