/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.util.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public abstract class KitchenSinkRenderer<T extends KitchenSinkBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Logger LOGGER = Logging.logger();
    private static final float PX = 0.0625f;
    private static final float X_START = 0.125f;
    private static final float X_END = 0.8125f;
    private static final float Z_START = 0.125f;
    private static final float Z_END = 0.875f;
    private static final float Y_START = 0.4375f;
    private static final float Y_END = 0.9375f;
    private static final double LITRES_PER_BLOCK = 1000.0;
    private static final float WAVE_PERIOD = 12000.0f;
    private static final float WAVE_HEIGHT = 0.0625f;
    private static final float MS_PER_TICK = 50.0f;

    private static float getRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 0.0f;
            case Direction.NORTH -> 90.0f;
            case Direction.WEST -> 180.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }

    protected KitchenSinkRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.isEmpty(entity)) {
            return;
        }
        TextureAtlasSprite sprite = this.getFluidSprite(entity);
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation()));
        float u0 = Mth.lerp((float)0.125f, (float)sprite.getU0(), (float)sprite.getU1());
        float u1 = Mth.lerp((float)0.875f, (float)sprite.getU0(), (float)sprite.getU1());
        float v0 = Mth.lerp((float)0.125f, (float)sprite.getV0(), (float)sprite.getV1());
        float v1 = Mth.lerp((float)0.8125f, (float)sprite.getV0(), (float)sprite.getV1());
        matrices.pushPose();
        matrices.translate(0.5, 0.0, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(KitchenSinkRenderer.getRotation((Direction)entity.getBlockState().getValue((Property)AbstractKitchenCounterBlock.FACING))));
        matrices.translate(-0.5, 0.0, -0.5);
        double fluidLevel = this.getFluidLevel(entity) / 1000.0;
        matrices.translate(0.0, Mth.lerp((double)fluidLevel, (double)0.4375, (double)0.9375), 0.0);
        PoseStack.Pose matrixEntry = matrices.last();
        Matrix4f positionMatrix = matrixEntry.pose();
        int color = this.getFluidColor(entity);
        buffer.addVertex(positionMatrix, 0.125f, KitchenSinkRenderer.computeY(0.125f, 0.875f), 0.875f).setColor(color).setUv(u0, v0).setOverlay(overlay).setLight(light).setNormal(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(positionMatrix, 0.8125f, KitchenSinkRenderer.computeY(0.8125f, 0.875f), 0.875f).setColor(color).setUv(u0, v1).setOverlay(overlay).setLight(light).setNormal(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(positionMatrix, 0.8125f, KitchenSinkRenderer.computeY(0.8125f, 0.125f), 0.125f).setColor(color).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(positionMatrix, 0.125f, KitchenSinkRenderer.computeY(0.125f, 0.125f), 0.125f).setColor(color).setUv(u1, v0).setOverlay(overlay).setLight(light).setNormal(matrixEntry, 0.0f, 1.0f, 0.0f);
        matrices.popPose();
    }

    private static float computeY(float x, float z) {
        float time = (float)Minecraft.getInstance().player.tickCount * 50.0f % 12000.0f;
        float t = time * ((float)Math.PI * 2) / 12000.0f;
        return Mth.sin((float)(t + x + z)) * 0.0625f / 2.0f;
    }

    private TextureAtlasSprite getFluidSprite(T entity) {
        TextureAtlasSprite sprite = FluidRenderingBridge.get().getStillSprite(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference());
        if (sprite == null) {
            LOGGER.error("Could not find sprite for fluid reference {} when rendering kitchen sink at {}", (Object)((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (Object)entity.getBlockPos());
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(MissingTextureAtlasSprite.getLocation());
        }
        return sprite;
    }

    private int getFluidColor(T entity) {
        return FluidRenderingBridge.get().getColor(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (BlockAndTintGetter)entity.getLevel(), entity.getBlockPos());
    }

    protected abstract double getFluidLevel(T var1);

    protected abstract boolean isEmpty(T var1);
}

