/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public final class BrewerScreen
extends AdornMenuScreen<BrewerMenu> {
    private static final Logger LOGGER = Logging.logger();
    public static final ResourceLocation TEXTURE = AdornCommon.id("textures/gui/brewer.png");
    public static final int FLUID_AREA_HEIGHT = 59;

    public BrewerScreen(BrewerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        BrewerScreen.drawFluid(context, this.leftPos + 145, this.topPos + 17, ((BrewerMenu)this.menu).getFluid());
        context.blit(TEXTURE, this.leftPos + 145, this.topPos + 21, 176, 25, 16, 51);
        int progress = ((BrewerMenu)this.menu).getProgress();
        if (progress > 0) {
            float progressFract = (float)progress / 200.0f;
            context.blit(TEXTURE, this.leftPos + 84, this.topPos + 24, 176, 0, 8, Mth.ceil((float)(progressFract * 25.0f)));
        }
    }

    protected void renderTooltip(GuiGraphics context, int x, int y) {
        super.renderTooltip(context, x, y);
        int x2 = x - this.leftPos;
        int y2 = y - this.topPos;
        if (145 <= x2 && x2 < 161 && 17 <= y2 && y2 < 76) {
            context.renderComponentTooltip(this.font, this.getFluidTooltip(((BrewerMenu)this.menu).getFluid()), x, y);
        }
    }

    private List<Component> getFluidTooltip(FluidReference fluid) {
        return FluidRenderingBridge.get().getTooltip(fluid, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL), 2000);
    }

    public static void setFluidFromPacket(Minecraft client, int syncId, FluidVolume fluid) {
        Screen screen = client.screen;
        if (screen instanceof MenuAccess) {
            MenuAccess menuProvider = (MenuAccess)screen;
            AbstractContainerMenu menu = menuProvider.getMenu();
            if (menu.containerId == syncId && menu instanceof BrewerMenu) {
                BrewerMenu brewerMenu = (BrewerMenu)menu;
                brewerMenu.setFluid(fluid);
            }
        }
    }

    private static void drawSprite(GuiGraphics context, int x, float y, float width, float height, float u0, float v0, float u1, float v1, TextureAtlasSprite sprite, int color) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        Matrix4f positionMatrix = context.pose().last().pose();
        float au0 = Mth.lerp((float)u0, (float)sprite.getU0(), (float)sprite.getU1());
        float au1 = Mth.lerp((float)u1, (float)sprite.getU0(), (float)sprite.getU1());
        float av0 = Mth.lerp((float)v0, (float)sprite.getV0(), (float)sprite.getV1());
        float av1 = Mth.lerp((float)v1, (float)sprite.getV0(), (float)sprite.getV1());
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(positionMatrix, (float)x, y + height, 0.0f).setUv(au0, av1).setColor(color);
        buffer.addVertex(positionMatrix, (float)x + width, y + height, 0.0f).setUv(au1, av1).setColor(color);
        buffer.addVertex(positionMatrix, (float)x + width, y, 0.0f).setUv(au1, av0).setColor(color);
        buffer.addVertex(positionMatrix, (float)x, y, 0.0f).setUv(au0, av0).setColor(color);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawFluid(GuiGraphics context, int x, int y, FluidReference fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        FluidRenderingBridge bridge = FluidRenderingBridge.get();
        TextureAtlasSprite sprite = bridge.getStillSprite(fluid);
        if (sprite == null) {
            LOGGER.warn("Could not find sprite for {} in brewer screen", (Object)fluid);
            return;
        }
        int color = Colors.color(bridge.getColor(fluid));
        float height = 59.0f * ((float)fluid.getAmount() / (float)(2L * fluid.getUnit().getBucketVolume()));
        int fluidY = 0;
        int tiles = Mth.floor((float)(height / 16.0f));
        for (int i = 0; i < tiles; ++i) {
            BrewerScreen.drawSprite(context, x, (float)y + BrewerScreen.transformY(bridge, fluid, fluidY, 16.0f), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, sprite, color);
            fluidY += 16;
        }
        float leftover = height % 16.0f;
        BrewerScreen.drawSprite(context, x, (float)y + BrewerScreen.transformY(bridge, fluid, fluidY, leftover), 16.0f, leftover, 0.0f, 0.0f, 1.0f, leftover / 16.0f, sprite, color);
    }

    private static float transformY(FluidRenderingBridge bridge, FluidReference fluid, int fluidY, float areaHeight) {
        if (bridge.fillsFromTop(fluid)) {
            return fluidY;
        }
        return (float)(59 - fluidY) - areaHeight;
    }
}

