/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.gui.widget.ConfigScreenHeading;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.Displayable;
import juuxel.adorn.util.PropertyRef;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.AnimationTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class AbstractConfigScreen
extends Screen {
    private static final int CONFIG_BUTTON_START_Y = 40;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_GAP = 4;
    public static final int BUTTON_SPACING = 24;
    private static final int HEART_SIZE = 12;
    private static final int[] HEART_COLORS = new int[]{-65536, -227582, -256, -5768104, -13803012, -6290692, -10950148, -220705};
    private static final ResourceLocation HEART_TEXTURE = AdornCommon.id("textures/gui/heart.png");
    private static final double MIN_HEART_SPEED = 0.05;
    private static final double MAX_HEART_SPEED = 1.5;
    private static final double MAX_HEART_ANGULAR_SPEED = 0.07;
    private static final int HEART_CHANCE = 65;
    private final Screen parent;
    private final Random random = new Random();
    private final List<Heart> hearts = new ArrayList<Heart>();
    private boolean restartRequired = false;
    private final AnimationEngine animationEngine = new AnimationEngine();
    protected int nextChildY = 40;

    protected AbstractConfigScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
        this.animationEngine.add(new HeartAnimationTask());
    }

    protected void init() {
        this.nextChildY = 40;
        this.animationEngine.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        List<Heart> list = this.hearts;
        synchronized (list) {
            this.renderHearts(context, delta);
        }
        context.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
        super.render(context, mouseX, mouseY, delta);
    }

    private void renderHearts(GuiGraphics context, float delta) {
        for (Heart heart : this.hearts) {
            RenderSystem.setShaderColor((float)Colors.redOf(heart.color), (float)Colors.greenOf(heart.color), (float)Colors.blueOf(heart.color), (float)1.0f);
            PoseStack matrices = context.pose();
            matrices.pushPose();
            matrices.translate((double)heart.x, Mth.lerp((double)delta, (double)heart.previousY, (double)heart.y), 0.0);
            matrices.translate(6.0, 6.0, 0.0);
            double angle = Mth.lerp((double)delta, (double)heart.previousAngle, (double)heart.angle);
            matrices.mulPose(Axis.ZP.rotation((float)angle));
            matrices.translate(-6.0, -6.0, 0.0);
            context.blit(HEART_TEXTURE, 0, 0, 12, 12, 0.0f, 0.0f, 8, 8, 8, 8);
            matrices.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)(this.restartRequired ? new AlertScreen(() -> this.minecraft.setScreen(this.parent), (Component)Component.translatable((String)"gui.adorn.config.restart_required.title"), (Component)Component.translatable((String)"gui.adorn.config.restart_required.message"), (Component)Component.translatable((String)"gui.ok"), true) : this.parent));
    }

    public void removed() {
        this.animationEngine.stop();
    }

    private void tickHearts() {
        Iterator<Heart> iter = this.hearts.iterator();
        while (iter.hasNext()) {
            Heart heart = iter.next();
            if (heart.y - 12.0 > (double)this.height) {
                iter.remove();
                continue;
            }
            heart.move();
        }
        if (this.random.nextInt(65) == 0) {
            int x = this.random.nextInt(this.width);
            int color = HEART_COLORS[this.random.nextInt(HEART_COLORS.length)];
            double speed = this.random.nextDouble(0.05, 1.5);
            double angularSpeed = this.random.nextDouble(-0.07, 0.07);
            this.hearts.add(new Heart(x, -12.0, color, speed, angularSpeed));
        }
    }

    private <T> CycleButton<T> createConfigButton(CycleButton.Builder<T> builder, int x, int y, int width, PropertyRef<T> property, boolean restartRequired) {
        return builder.withTooltip(value -> {
            MutableComponent text = Component.translatable((String)this.getTooltipTranslationKey(property.getName()));
            if (restartRequired) {
                text.append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"gui.adorn.config.requires_restart").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
            }
            return Tooltip.create((Component)text);
        }).create(x, y, width, 20, (Component)Component.translatable((String)this.getOptionTranslationKey(property.getName())), (button, value) -> {
            property.set(value);
            ConfigManager.get().save();
            if (restartRequired) {
                this.restartRequired = true;
            }
        });
    }

    protected void addConfigToggle(int width, PropertyRef<Boolean> property) {
        this.addConfigToggle(width, property, false);
    }

    protected void addConfigToggle(int width, PropertyRef<Boolean> property, boolean restartRequired) {
        CycleButton<Boolean> button = this.createConfigButton(CycleButton.onOffBuilder((boolean)property.get()), (this.width - width) / 2, this.nextChildY, width, property, restartRequired);
        this.addRenderableWidget((GuiEventListener)button);
        this.nextChildY += 24;
    }

    protected <T extends Displayable> void addConfigButton(int width, PropertyRef<T> property, List<T> values) {
        this.addConfigButton(width, property, values, false);
    }

    protected <T extends Displayable> void addConfigButton(int width, PropertyRef<T> property, List<T> values, boolean restartRequired) {
        CycleButton<T> button = this.createConfigButton(CycleButton.builder(Displayable::getDisplayName).withValues(values).withInitialValue((Object)((Displayable)property.get())), (this.width - width) / 2, this.nextChildY, width, property, restartRequired);
        this.addRenderableWidget((GuiEventListener)button);
        this.nextChildY += 24;
    }

    protected void addHeading(Component text, int width) {
        this.addRenderableOnly(new ConfigScreenHeading(text, (this.width - width) / 2, this.nextChildY, width));
        this.nextChildY += 18;
    }

    protected String getOptionTranslationKey(String name) {
        return "gui.adorn.config.option." + name;
    }

    private String getTooltipTranslationKey(String name) {
        return this.getOptionTranslationKey(name) + ".description";
    }

    private final class HeartAnimationTask
    implements AnimationTask {
        private HeartAnimationTask() {
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tick() {
            List<Heart> list = AbstractConfigScreen.this.hearts;
            synchronized (list) {
                AbstractConfigScreen.this.tickHearts();
            }
        }
    }

    private static final class Heart {
        private final int x;
        private double y;
        private final int color;
        private final double speed;
        private final double angularSpeed;
        private double previousY;
        private double previousAngle = 0.0;
        private double angle = 0.0;

        private Heart(int x, double y, int color, double speed, double angularSpeed) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.speed = speed;
            this.angularSpeed = angularSpeed;
            this.previousY = y;
        }

        private void move() {
            this.previousY = this.y;
            this.y += this.speed;
            this.previousAngle = this.angle;
            this.angle = (this.angle + this.angularSpeed) % 6.2831854820251465;
        }
    }
}

