/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.util.Logging;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class BookManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = Logging.logger();
    public static final String DATA_TYPE = "adorn/books";
    private static final Gson GSON = new Gson();
    private Map<ResourceLocation, Book> books = Map.of();

    public BookManager() {
        super(GSON, DATA_TYPE);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        this.books = prepared.entrySet().stream().map(entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            DataResult book = Book.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
            return (Pair)book.mapOrElse(pair -> Pair.of((Object)id, (Object)((Book)pair.getFirst())), error -> {
                LOGGER.error("Could not load book {}: {}", (Object)id, (Object)error.message());
                return null;
            });
        }).filter((Predicate<Pair>)Predicates.notNull()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public boolean contains(ResourceLocation id) {
        return this.books.containsKey(id);
    }

    public Book get(ResourceLocation id) {
        Book book = this.books.get(id);
        if (book == null) {
            throw new IllegalArgumentException("Tried to get unknown book '%s' from BookManager".formatted(id));
        }
        return book;
    }
}

