/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.variant;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.util.AdornUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public interface BlockVariant {
    public static final char MOD_ID_SEPARATOR = '/';
    public static final Map<DyeColor, BlockVariant> WOOLS = BlockVariant.createBy((Enum[])DyeColor.values(), (T color) -> BlockVariant.variant(color.getSerializedName(), Blocks.WHITE_WOOL));
    public static final Map<DyeColor, BlockVariant> PAINTED_WOODS = BlockVariant.createBy((Enum[])DyeColor.values(), PaintedWood::new);
    public static final BlockVariant IRON = BlockVariant.variant("iron", Blocks.IRON_BARS);
    public static final BlockVariant OAK = BlockVariant.variant("oak", Blocks.OAK_PLANKS);
    public static final BlockVariant SPRUCE = BlockVariant.variant("spruce", Blocks.SPRUCE_PLANKS);
    public static final BlockVariant BIRCH = BlockVariant.variant("birch", Blocks.BIRCH_PLANKS);
    public static final BlockVariant JUNGLE = BlockVariant.variant("jungle", Blocks.JUNGLE_PLANKS);
    public static final BlockVariant ACACIA = BlockVariant.variant("acacia", Blocks.ACACIA_PLANKS);
    public static final BlockVariant DARK_OAK = BlockVariant.variant("dark_oak", Blocks.DARK_OAK_PLANKS);
    public static final BlockVariant MANGROVE = BlockVariant.variant("mangrove", Blocks.MANGROVE_PLANKS);
    public static final BlockVariant CHERRY = BlockVariant.variant("cherry", Blocks.CHERRY_PLANKS);
    public static final BlockVariant BAMBOO = BlockVariant.variant("bamboo", Blocks.BAMBOO_PLANKS);
    public static final BlockVariant CRIMSON = BlockVariant.variant("crimson", Blocks.CRIMSON_PLANKS);
    public static final BlockVariant WARPED = BlockVariant.variant("warped", Blocks.WARPED_PLANKS);
    public static final BlockVariant STONE = BlockVariant.variant("stone", Blocks.STONE);
    public static final BlockVariant COBBLESTONE = BlockVariant.variant("cobblestone", Blocks.COBBLESTONE);
    public static final BlockVariant SANDSTONE = BlockVariant.variant("sandstone", Blocks.SANDSTONE);
    public static final BlockVariant DIORITE = BlockVariant.variant("diorite", Blocks.DIORITE);
    public static final BlockVariant ANDESITE = BlockVariant.variant("andesite", Blocks.ANDESITE);
    public static final BlockVariant GRANITE = BlockVariant.variant("granite", Blocks.GRANITE);
    public static final BlockVariant BRICK = BlockVariant.variant("brick", Blocks.BRICKS);
    public static final BlockVariant STONE_BRICK = BlockVariant.variant("stone_brick", Blocks.STONE_BRICKS);
    public static final BlockVariant RED_SANDSTONE = BlockVariant.variant("red_sandstone", Blocks.RED_SANDSTONE);
    public static final BlockVariant NETHER_BRICK = BlockVariant.variant("nether_brick", Blocks.NETHER_BRICKS);
    public static final BlockVariant BASALT = BlockVariant.variant("basalt", Blocks.BASALT);
    public static final BlockVariant BLACKSTONE = BlockVariant.variant("blackstone", Blocks.BLACKSTONE);
    public static final BlockVariant RED_NETHER_BRICK = BlockVariant.variant("red_nether_brick", Blocks.RED_NETHER_BRICKS);
    public static final BlockVariant PRISMARINE = BlockVariant.variant("prismarine", Blocks.PRISMARINE);
    public static final BlockVariant QUARTZ = BlockVariant.variant("quartz", Blocks.QUARTZ_BLOCK);
    public static final BlockVariant END_STONE_BRICK = BlockVariant.variant("end_stone_brick", Blocks.END_STONE_BRICKS);
    public static final BlockVariant PURPUR = BlockVariant.variant("purpur", Blocks.PURPUR_BLOCK);
    public static final BlockVariant POLISHED_BLACKSTONE = BlockVariant.variant("polished_blackstone", Blocks.POLISHED_BLACKSTONE);
    public static final BlockVariant POLISHED_BLACKSTONE_BRICK = BlockVariant.variant("polished_blackstone_brick", Blocks.POLISHED_BLACKSTONE_BRICKS);
    public static final BlockVariant POLISHED_DIORITE = BlockVariant.variant("polished_diorite", Blocks.POLISHED_DIORITE);
    public static final BlockVariant POLISHED_ANDESITE = BlockVariant.variant("polished_andesite", Blocks.POLISHED_ANDESITE);
    public static final BlockVariant POLISHED_GRANITE = BlockVariant.variant("polished_granite", Blocks.POLISHED_GRANITE);
    public static final BlockVariant PRISMARINE_BRICK = BlockVariant.variant("prismarine_brick", Blocks.PRISMARINE_BRICKS);
    public static final BlockVariant DARK_PRISMARINE = BlockVariant.variant("dark_prismarine", Blocks.DARK_PRISMARINE);
    public static final BlockVariant CUT_SANDSTONE = BlockVariant.variant("cut_sandstone", Blocks.CUT_SANDSTONE);
    public static final BlockVariant SMOOTH_SANDSTONE = BlockVariant.variant("smooth_sandstone", Blocks.SMOOTH_SANDSTONE);
    public static final BlockVariant CUT_RED_SANDSTONE = BlockVariant.variant("cut_red_sandstone", Blocks.CUT_RED_SANDSTONE);
    public static final BlockVariant SMOOTH_RED_SANDSTONE = BlockVariant.variant("smooth_red_sandstone", Blocks.SMOOTH_RED_SANDSTONE);
    public static final BlockVariant SMOOTH_STONE = BlockVariant.variant("smooth_stone", Blocks.SMOOTH_STONE);
    public static final BlockVariant MOSSY_COBBLESTONE = BlockVariant.variant("mossy_cobblestone", Blocks.MOSSY_COBBLESTONE);
    public static final BlockVariant MOSSY_STONE_BRICK = BlockVariant.variant("mossy_stone_brick", Blocks.MOSSY_STONE_BRICKS);
    public static final BlockVariant DEEPSLATE = BlockVariant.variant("deepslate", Blocks.DEEPSLATE);
    public static final BlockVariant COBBLED_DEEPSLATE = BlockVariant.variant("cobbled_deepslate", Blocks.COBBLED_DEEPSLATE);
    public static final BlockVariant POLISHED_DEEPSLATE = BlockVariant.variant("polished_deepslate", Blocks.POLISHED_DEEPSLATE);
    public static final BlockVariant DEEPSLATE_BRICK = BlockVariant.variant("deepslate_brick", Blocks.DEEPSLATE_BRICKS);
    public static final BlockVariant DEEPSLATE_TILE = BlockVariant.variant("deepslate_tile", Blocks.DEEPSLATE_TILES);
    public static final BlockVariant TUFF = BlockVariant.variant("tuff", Blocks.TUFF);
    public static final BlockVariant POLISHED_TUFF = BlockVariant.variant("polished_tuff", Blocks.POLISHED_TUFF);
    public static final BlockVariant TUFF_BRICK = BlockVariant.variant("tuff_brick", Blocks.TUFF_BRICKS);

    public String name();

    default public ResourceLocation nameAsIdentifier() {
        String name = this.name();
        return ResourceLocation.bySeparator((String)name, (char)'/');
    }

    public BlockBehaviour.Properties createSettings();

    public static BlockVariant variant(final String name, final Block base) {
        return new BlockVariant(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public BlockBehaviour.Properties createSettings() {
                return AdornUtil.copySettingsSafely(base);
            }
        };
    }

    public static BlockVariant wool(DyeColor color) {
        return WOOLS.get(color);
    }

    private static <K extends Enum<K>> Map<K, BlockVariant> createBy(K[] keys, Function<K, BlockVariant> factory) {
        Class<?> keyType = keys[0].getClass();
        return Collections.unmodifiableMap(Arrays.stream(keys).map(key -> Pair.of((Object)key, (Object)((BlockVariant)factory.apply(key)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a, () -> new EnumMap(keyType))));
    }

    public record PaintedWood(DyeColor color) implements BlockVariant
    {
        @Override
        public String name() {
            return this.color.getName();
        }

        @Override
        public ResourceLocation nameAsIdentifier() {
            return AdornCommon.id(this.name());
        }

        @Override
        public BlockBehaviour.Properties createSettings() {
            return AdornUtil.copySettingsSafely(AdornBlocks.PAINTED_PLANKS.getEager(this.color));
        }
    }

    public record Stone(String name) implements BlockVariant
    {
        @Override
        public BlockBehaviour.Properties createSettings() {
            return AdornUtil.copySettingsSafely(Blocks.COBBLESTONE);
        }
    }

    public record Wood(String name) implements BlockVariant
    {
        @Override
        public BlockBehaviour.Properties createSettings() {
            return AdornUtil.copySettingsSafely(Blocks.OAK_PLANKS);
        }
    }
}

