/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.lib.AdornGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public abstract class KitchenSinkBlockEntity
extends BlockEntity {
    public KitchenSinkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AdornBlockEntities.KITCHEN_SINK.get(), pos, state);
    }

    public abstract FluidReference getFluidReference();

    public abstract boolean interactWithItem(ItemStack var1, Player var2, InteractionHand var3);

    public abstract boolean clearFluidsWithSponge();

    protected void onFill(ItemStack stack, Player player) {
        this.level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, this.worldPosition);
        player.playSound(this.getEmptySound((FluidReference)this.getFluidReference(), (ItemStack)stack).event, 1.0f, 1.0f);
    }

    protected void onPickUp(FluidReference fluid, ItemStack stack, Player player) {
        this.level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, this.worldPosition);
        player.level().playSound(player, player.getX(), player.getY(), player.getZ(), this.getFillSound((FluidReference)fluid, (ItemStack)stack).event, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected FluidItemSound getFillSound(FluidReference fluid, ItemStack stack) {
        if (stack.is(Items.GLASS_BOTTLE)) {
            return new FluidItemSound(SoundEvents.BOTTLE_FILL, true);
        }
        return new FluidItemSound(fluid.getFluid().getPickupSound().orElse(SoundEvents.BUCKET_FILL), false);
    }

    protected FluidItemSound getEmptySound(FluidReference fluid, ItemStack stack) {
        if (KitchenSinkBlockEntity.isWaterBottle(stack)) {
            return new FluidItemSound(SoundEvents.BOTTLE_EMPTY, true);
        }
        return new FluidItemSound(fluid.getFluid().is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY, false);
    }

    protected static boolean isWaterBottle(ItemStack stack) {
        if (!stack.is(Items.POTION)) {
            return false;
        }
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return potionContents.is(Potions.WATER);
    }

    protected void markDirtyAndSync() {
        this.setChanged();
        if (!this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public abstract int calculateComparatorOutput();

    private static boolean isInfinite(Fluid fluid, Level world) {
        FlowingFluid flowable;
        return fluid instanceof FlowingFluid && (flowable = (FlowingFluid)fluid).canConvertToSource(world);
    }

    public static boolean supportsInfiniteExtraction(Level world, Fluid fluid) {
        return KitchenSinkBlockEntity.isInfinite(fluid, world) && world.getGameRules().getBoolean(AdornGameRules.INFINITE_KITCHEN_SINKS);
    }

    public record FluidItemSound(SoundEvent event, boolean preferred) {
        public FluidItemSound orElse(@Nullable SoundEvent fallback) {
            if (this.preferred) {
                return this;
            }
            return fallback != null ? new FluidItemSound(fallback, true) : this;
        }
    }
}

