/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.criterion.BoughtFromTradingStationCriterion;
import juuxel.adorn.lib.AdornGameRules;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.trading.TradeOwner;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class TradingStationBlock
extends VisibleBlockWithEntity
implements BlockWithDescription {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String OWNER_DESCRIPTION = "block.adorn.trading_station.description.owner";
    private static final VoxelShape OUTLINE_SHAPE = Shapes.or((VoxelShape)TradingStationBlock.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TradingStationBlock.createLegShape());
    private static final VoxelShape COLLISION_SHAPE = Shapes.or((VoxelShape)TradingStationBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TradingStationBlock.createLegShape());

    public TradingStationBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof TradingStationBlockEntity) {
                TradingStationBlockEntity tradingStation = (TradingStationBlockEntity)blockEntity;
                tradingStation.setOwner(player);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TradingStationBlockEntity) {
            TradingStationBlockEntity be = (TradingStationBlockEntity)blockEntity;
            if (be.getOwner() == null) {
                be.setOwner(player);
            }
            if (!be.isOwner(player)) {
                Trade trade = be.getTrade();
                boolean validPayment = ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)trade.getPrice()) && stack.getCount() >= trade.getPrice().getCount();
                boolean canInsertPayment = be.getStorage().canInsert(trade.getPrice());
                if (trade.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.adorn.trading_station.empty_trade"), true);
                } else if (!be.isStorageStocked()) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.adorn.trading_station.storage_not_stocked"), true);
                } else if (!canInsertPayment) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.adorn.trading_station.storage_full"), true);
                } else if (validPayment) {
                    stack.shrink(trade.getPrice().getCount());
                    ItemStack soldItem = trade.getSelling().copy();
                    player.addItem(soldItem);
                    be.getStorage().tryExtract(trade.getSelling());
                    be.getStorage().tryInsert(trade.getPrice());
                    player.awardStat(AdornStats.INTERACT_WITH_TRADING_STATION);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((BoughtFromTradingStationCriterion)((Object)AdornCriteria.BOUGHT_FROM_TRADING_STATION.get())).trigger(serverPlayer, soldItem);
                    }
                }
            } else {
                player.openMenu((MenuProvider)be);
                player.awardStat(AdornStats.INTERACT_WITH_TRADING_STATION);
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = world.getBlockEntity(pos)) instanceof TradingStationBlockEntity) {
            TradingStationBlockEntity tradingStation = (TradingStationBlockEntity)blockEntity;
            if (!world.getGameRules().getBoolean(AdornGameRules.DROP_LOCKED_TRADING_STATIONS)) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)tradingStation.getStorage());
            }
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AdornBlockEntities.TRADING_STATION.get()).create(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        TradeOwner owner = (TradeOwner)stack.get((DataComponentType)AdornComponentTypes.TRADE_OWNER.get());
        if (owner != null) {
            tooltip.add((Component)Component.translatable((String)OWNER_DESCRIPTION, (Object[])new Object[]{owner.name().copy().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GREEN));
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException();
    }

    private static VoxelShape createLegShape() {
        return Shapes.or((VoxelShape)TradingStationBlock.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), (VoxelShape[])new VoxelShape[]{TradingStationBlock.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), TradingStationBlock.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), TradingStationBlock.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0)});
    }
}

