/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.Shapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class ShelfBlock
extends VisibleBlockWithEntity
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String DESCRIPTION_KEY = "block.adorn.shelf.description";
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.buildShapeRotations(0, 5, 0, 7, 6, 16);

    public ShelfBlock(BlockVariant variant) {
        super(variant.createSettings());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos neighborPos = pos.relative(facing.getOpposite());
        return world.getBlockState(neighborPos).isFaceSturdy((BlockGetter)world, neighborPos, facing);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        for (Direction direction : ctx.getNearestLookingDirections()) {
            BlockState state;
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == direction && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof Container)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Container inventory = (Container)be;
        int slot = this.getSlot(state, hit);
        ItemStack existing = inventory.getItem(slot);
        if (existing.isEmpty()) {
            if (!stack.isEmpty()) {
                ItemStack copy = stack.copy();
                copy.setCount(1);
                inventory.setItem(slot, copy);
                be.setChanged();
                if (!world.isClientSide) {
                    PlatformBridges.get().getNetwork().syncBlockEntity(be);
                    player.awardStat(AdornStats.INTERACT_WITH_SHELF);
                }
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        } else {
            if (!world.isClientSide) {
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, existing);
                } else {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)existing);
                }
            }
            inventory.setItem(slot, ItemStack.EMPTY);
            be.setChanged();
            if (!world.isClientSide) {
                PlatformBridges.get().getNetwork().syncBlockEntity(be);
                player.awardStat(AdornStats.INTERACT_WITH_SHELF);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private int getSlot(BlockState state, BlockHitResult hitResult) {
        BlockPos blockPos = hitResult.getBlockPos();
        Vec3 pos = hitResult.getLocation();
        double xo = pos.x - (double)blockPos.getX();
        double zo = pos.z - (double)blockPos.getZ();
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction side = hitResult.getDirection();
        if (side == facing || side == Direction.UP || side == Direction.DOWN || side == facing.getOpposite()) {
            return switch (facing) {
                case Direction.EAST -> {
                    if (zo <= 0.5) {
                        yield 0;
                    }
                    yield 1;
                }
                case Direction.WEST -> {
                    if (zo <= 0.5) {
                        yield 1;
                    }
                    yield 0;
                }
                case Direction.NORTH -> {
                    if (xo <= 0.5) {
                        yield 0;
                    }
                    yield 1;
                }
                case Direction.SOUTH -> {
                    if (xo <= 0.5) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> -1;
            };
        }
        if (side == facing.getCounterClockWise()) {
            return 1;
        }
        if (side == facing.getClockWise()) {
            return 0;
        }
        return -1;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AdornBlockEntities.SHELF.get()).create(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException();
    }
}

