/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.AbstractChimneyBlock;
import juuxel.adorn.block.BlockWithDescription;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PrismarineChimneyBlock
extends AbstractChimneyBlock
implements BlockWithDescription {
    private static final String DESCRIPTION_KEY = "block.adorn.prismarine_chimney.description";

    public PrismarineChimneyBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!state.getFluidState().is(FluidTags.WATER) || ((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.9;
        double z = (double)pos.getZ() + 0.5;
        for (int i = 0; i < 3; ++i) {
            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static final class WithColumn
    extends PrismarineChimneyBlock {
        private final boolean drag;

        public WithColumn(boolean drag, BlockBehaviour.Properties settings) {
            super(settings);
            this.drag = drag;
        }

        public boolean getDrag() {
            return this.drag;
        }

        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
            BubbleColumnBlock.updateColumn((LevelAccessor)world, (BlockPos)pos.above(), (BlockState)state);
        }

        public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
            world.scheduleTick(pos, (Block)this, 20);
        }

        public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
            world.scheduleTick(pos, (Block)this, 20);
        }

        @Override
        public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
            if (!this.drag) {
                super.animateTick(state, world, pos, random);
            }
        }
    }
}

