/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.entity.DrawerBlockEntity;
import juuxel.adorn.block.entity.SimpleContainerBlockEntity;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.Shapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class DrawerBlock
extends VisibleBlockWithEntity
implements BlockWithDescription {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(0, 0, 3, 16, 16, 16), Shapes.buildShapeRotationsFromNorth(1, 9, 1, 15, 15, 3), Shapes.buildShapeRotationsFromNorth(1, 1, 1, 15, 7, 3));
    private static final String DESCRIPTION_KEY = "block.adorn.drawer.description";

    public DrawerBlock(BlockVariant variant) {
        super(variant.createSettings().noOcclusion());
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof DrawerBlockEntity) {
            DrawerBlockEntity drawer = (DrawerBlockEntity)blockEntity;
            PlatformBridges.get().getMenus().open(player, (MenuProvider)drawer, pos);
            player.awardStat(AdornStats.OPEN_DRAWER);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AdornBlockEntities.DRAWER.get()).create(pos, state);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SimpleContainerBlockEntity) {
            SimpleContainerBlockEntity container = (SimpleContainerBlockEntity)blockEntity;
            container.onScheduledTick();
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException();
    }
}

