/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.HashSet;
import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.lib.AdornTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperPipeBlock
extends Block
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final BooleanProperty NORTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty WEST;
    public static final BooleanProperty UP;
    public static final BooleanProperty DOWN;
    public static final BooleanProperty WATERLOGGED;
    private static final String DESCRIPTION_KEY = "block.adorn.copper_pipe.description";
    private static final VoxelShape[] SHAPES;

    public CopperPipeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[CopperPipeBlock.getShapeKey((Boolean)state.getValue((Property)NORTH), (Boolean)state.getValue((Property)EAST), (Boolean)state.getValue((Property)SOUTH), (Boolean)state.getValue((Property)WEST), (Boolean)state.getValue((Property)UP), (Boolean)state.getValue((Property)DOWN))];
    }

    private static int getShapeKey(boolean north, boolean east, boolean south, boolean west, boolean up, boolean down) {
        int northB = north ? 1 : 0;
        int eastB = east ? 1 : 0;
        int southB = south ? 1 : 0;
        int westB = west ? 1 : 0;
        int upB = up ? 1 : 0;
        int downB = down ? 1 : 0;
        return northB << 5 | eastB << 4 | southB << 3 | westB << 2 | upB << 1 | downB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
        for (Direction direction : Direction.values()) {
            state = this.updateConnection(state, ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction)), direction);
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateConnection(state, neighborState, direction);
    }

    private BlockState updateConnection(BlockState state, BlockState neighborState, Direction direction) {
        BooleanProperty property = switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
        return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(CopperPipeBlock.shouldConnectTo(neighborState)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    private static boolean shouldConnectTo(BlockState state) {
        return state.is(AdornTags.COPPER_PIPES_CONNECT_TO);
    }

    static {
        boolean[] booleans;
        NORTH = BlockStateProperties.NORTH;
        EAST = BlockStateProperties.EAST;
        SOUTH = BlockStateProperties.SOUTH;
        WEST = BlockStateProperties.WEST;
        UP = BlockStateProperties.UP;
        DOWN = BlockStateProperties.DOWN;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        SHAPES = new VoxelShape[64];
        VoxelShape center = CopperPipeBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        Map<Direction, VoxelShape> pipes = juuxel.adorn.util.Shapes.buildShapeRotationsFromNorth(7, 7, 0, 9, 9, 8);
        pipes.put(Direction.UP, CopperPipeBlock.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
        pipes.put(Direction.DOWN, CopperPipeBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0));
        VoxelShape ringX = CopperPipeBlock.box((double)7.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0, (double)10.0);
        VoxelShape ringY = CopperPipeBlock.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
        VoxelShape ringZ = CopperPipeBlock.box((double)6.0, (double)6.0, (double)7.0, (double)10.0, (double)10.0, (double)9.0);
        for (boolean north : booleans = new boolean[]{true, false}) {
            for (boolean east : booleans) {
                for (boolean south : booleans) {
                    for (boolean west : booleans) {
                        for (boolean up : booleans) {
                            for (boolean down : booleans) {
                                boolean hasCenter;
                                HashSet<Direction.Axis> axes = new HashSet<Direction.Axis>();
                                if (west || east) {
                                    axes.add(Direction.Axis.X);
                                }
                                if (up || down) {
                                    axes.add(Direction.Axis.Y);
                                }
                                if (north || south) {
                                    axes.add(Direction.Axis.Z);
                                }
                                boolean bl = hasCenter = !north && !east && !south && !west && !up && !down || north && !south || east && !west || south && !north || west && !east || up && !down || down && !up || axes.size() > 1;
                                VoxelShape shape = hasCenter ? center : (east ? ringX : (up ? ringY : ringZ));
                                if (north) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.NORTH));
                                }
                                if (east) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.EAST));
                                }
                                if (south) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.SOUTH));
                                }
                                if (west) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.WEST));
                                }
                                if (up) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.UP));
                                }
                                if (down) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)pipes.get(Direction.DOWN));
                                }
                                CopperPipeBlock.SHAPES[CopperPipeBlock.getShapeKey((boolean)north, (boolean)east, (boolean)south, (boolean)west, (boolean)up, (boolean)down)] = shape;
                            }
                        }
                    }
                }
            }
        }
    }
}

