/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.CarpetedBlock;
import juuxel.adorn.block.FluidUtil;
import juuxel.adorn.block.property.OptionalProperty;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.lib.AdornStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class ChairBlock
extends CarpetedBlock
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String DESCRIPTION_KEY = "block.adorn.chair.description";
    private static final Map<Direction, VoxelShape> LOWER_SHAPES;
    private static final Map<Direction, VoxelShape> LOWER_SHAPES_WITH_CARPET;
    private static final Map<Direction, VoxelShape> UPPER_OUTLINE_SHAPES;

    public ChairBlock(BlockVariant variant) {
        super(variant.createSettings());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getSittingStat() {
        return AdornStats.SIT_ON_CHAIR;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HALF, WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (pos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState downState = world.getBlockState(pos.below());
            return downState.getBlock() == this && downState.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(state, world, pos);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            DoublePlantBlock.preventDropFromBottomPart((Level)world, (BlockPos)pos, (BlockState)state, (Player)player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        world.setBlockAndUpdate(pos.above(), FluidUtil.updateFluidFromState((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), world.getFluidState(pos.above())));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.getValue((Property)CARPET)).isPresent()) {
                return LOWER_SHAPES_WITH_CARPET.get(state.getValue((Property)FACING));
            }
            return LOWER_SHAPES.get(state.getValue((Property)FACING));
        }
        return UPPER_OUTLINE_SHAPES.get(state.getValue((Property)FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.getValue((Property)CARPET)).isPresent()) {
                return LOWER_SHAPES_WITH_CARPET.get(state.getValue((Property)FACING));
            }
            return LOWER_SHAPES.get(state.getValue((Property)FACING));
        }
        return Shapes.empty();
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            if (neighborState.getBlock() != this) {
                return Blocks.AIR.defaultBlockState();
            }
            return (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)neighborState.getValue((Property)FACING)));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected BlockPos getActualSeatPos(Level world, BlockState state, BlockPos pos) {
        return switch ((DoubleBlockHalf)state.getValue(HALF)) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> pos.below();
            case DoubleBlockHalf.LOWER -> pos;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public boolean canStateBeCarpeted(BlockState state) {
        return super.canStateBeCarpeted(state) && state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public double getSittingOffset(Level world, BlockState state, BlockPos pos) {
        return 0.625;
    }

    static {
        VoxelShape lowerSeatShape = Shapes.or((VoxelShape)ChairBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), (VoxelShape[])new VoxelShape[]{ChairBlock.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), ChairBlock.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), ChairBlock.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), ChairBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0)});
        Map<Direction, VoxelShape> lowerBackShapes = juuxel.adorn.util.Shapes.buildShapeRotations(2, 10, 2, 4, 24, 14);
        LOWER_SHAPES = juuxel.adorn.util.Shapes.mergeIntoShapeMap(lowerBackShapes, lowerSeatShape);
        LOWER_SHAPES_WITH_CARPET = juuxel.adorn.util.Shapes.mergeIntoShapeMap(LOWER_SHAPES, CARPET_SHAPE);
        VoxelShape upperSeatShape = Shapes.or((VoxelShape)ChairBlock.box((double)2.0, (double)-8.0, (double)2.0, (double)14.0, (double)-6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{ChairBlock.box((double)2.0, (double)-16.0, (double)2.0, (double)4.0, (double)-8.0, (double)4.0), ChairBlock.box((double)12.0, (double)-16.0, (double)2.0, (double)14.0, (double)-8.0, (double)4.0), ChairBlock.box((double)2.0, (double)-16.0, (double)12.0, (double)4.0, (double)-8.0, (double)14.0), ChairBlock.box((double)12.0, (double)-16.0, (double)12.0, (double)14.0, (double)-8.0, (double)14.0)});
        Map<Direction, VoxelShape> upperBackShapes = juuxel.adorn.util.Shapes.buildShapeRotations(2, -6, 2, 4, 8, 14);
        UPPER_OUTLINE_SHAPES = juuxel.adorn.util.Shapes.mergeIntoShapeMap(upperBackShapes, upperSeatShape);
    }
}

