/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.property.OptionalProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class CarpetedBlock
extends SeatBlock {
    public static final OptionalProperty<DyeColor> CARPET = new OptionalProperty(EnumProperty.create((String)"carpet", DyeColor.class));
    public static final VoxelShape CARPET_SHAPE = CarpetedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final Map<DyeColor, Block> COLORS_TO_BLOCKS = new EnumMap<DyeColor, Block>(DyeColor.class);

    public CarpetedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        if (this.isCarpetingEnabled()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CARPET, CARPET.getNone()));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        if (this.isCarpetingEnabled()) {
            builder.add(new Property[]{CARPET});
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (this.isCarpetingEnabled()) {
            return (BlockState)super.getStateForPlacement(ctx).setValue(CARPET, CARPET.wrapOrNone(CarpetedBlock.getCarpetColor(ctx)));
        }
        return super.getStateForPlacement(ctx);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Block carpetBlock;
        if (!this.isCarpetingEnabled()) {
            return;
        }
        OptionalProperty.Value carpet = (OptionalProperty.Value)state.getValue(CARPET);
        if (carpet.isPresent() && !(carpetBlock = COLORS_TO_BLOCKS.get(carpet.value())).defaultBlockState().canSurvive((LevelReader)world, pos)) {
            carpetBlock.playerWillDestroy((Level)world, pos, state, null);
            CarpetedBlock.dropResources((BlockState)carpetBlock.defaultBlockState(), (Level)world, (BlockPos)pos);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(CARPET, CARPET.getNone()));
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        OptionalProperty.Value carpet;
        if (this.isCarpetingEnabled() && (carpet = (OptionalProperty.Value)state.getValue(CARPET)).isPresent() && !COLORS_TO_BLOCKS.get(carpet.value()).defaultBlockState().canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.getValue(CARPET)).isPresent()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(super.getDrops(state, builder));
            stacks.addAll(COLORS_TO_BLOCKS.get(((OptionalProperty.Value)state.getValue(CARPET)).value()).defaultBlockState().getDrops(builder));
            return stacks;
        }
        return super.getDrops(state, builder);
    }

    public boolean isCarpetingEnabled() {
        return true;
    }

    public boolean canStateBeCarpeted(BlockState state) {
        return this.isCarpetingEnabled() && state.getValue(CARPET) == CARPET.getNone();
    }

    @Nullable
    private static DyeColor getCarpetColor(BlockPlaceContext context) {
        DyeColor dyeColor;
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        if (block instanceof WoolCarpetBlock) {
            WoolCarpetBlock carpet = (WoolCarpetBlock)block;
            dyeColor = carpet.getColor();
        } else {
            dyeColor = null;
        }
        return dyeColor;
    }

    static {
        COLORS_TO_BLOCKS.put(DyeColor.WHITE, Blocks.WHITE_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.ORANGE, Blocks.ORANGE_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.MAGENTA, Blocks.MAGENTA_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.YELLOW, Blocks.YELLOW_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.LIME, Blocks.LIME_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.PINK, Blocks.PINK_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.GRAY, Blocks.GRAY_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.CYAN, Blocks.CYAN_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.PURPLE, Blocks.PURPLE_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.BLUE, Blocks.BLUE_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.BROWN, Blocks.BROWN_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.GREEN, Blocks.GREEN_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.RED, Blocks.RED_CARPET);
        COLORS_TO_BLOCKS.put(DyeColor.BLACK, Blocks.BLACK_CARPET);
    }
}

