/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.BlockWithDescription;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;

public final class CandlelitLanternBlock
extends LanternBlock
implements BlockWithDescription {
    private static final String DESCRIPTION_KEY = "block.adorn.candlelit_lantern.description";

    public CandlelitLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double px = 0.0625;
        Vec3 vec = Vec3.upFromBottomCenterOf((Vec3i)pos, (double)((Boolean)state.getValue((Property)HANGING) != false ? 6.0 * px : 5.0 * px));
        AbstractCandleBlock.addParticlesAndSound((Level)world, (Vec3)vec, (RandomSource)random);
    }

    public static BlockBehaviour.Properties createBlockSettings() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 12).noOcclusion();
    }
}

