/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.AbstractChimneyBlock;
import juuxel.adorn.block.AdornBlockSetTypes;
import juuxel.adorn.block.AdornWoodTypes;
import juuxel.adorn.block.BrewerBlock;
import juuxel.adorn.block.CandlelitLanternBlock;
import juuxel.adorn.block.ChainLinkFenceBlock;
import juuxel.adorn.block.ChimneyBlock;
import juuxel.adorn.block.CopperPipeBlock;
import juuxel.adorn.block.OxidizableCopperPipeBlock;
import juuxel.adorn.block.PicketFenceBlock;
import juuxel.adorn.block.PrismarineChimneyBlock;
import juuxel.adorn.block.SofaBlock;
import juuxel.adorn.block.StoneLadderBlock;
import juuxel.adorn.block.TableLampBlock;
import juuxel.adorn.block.TradingStationBlock;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.item.TradingStationItem;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.RegisteredMap;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import juuxel.adorn.lib.registry.RegistryHelper;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.AdornUtil;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;

public final class AdornBlocks {
    public static final Registrar<Block> BLOCKS = RegistrarFactory.get().create(Registries.BLOCK);
    public static final Registrar<Item> ITEMS = RegistrarFactory.get().create(Registries.ITEM);
    private static final RegistryHelper HELPER = new RegistryHelper(BLOCKS, ITEMS);
    public static final RegisteredMap<DyeColor, SofaBlock> SOFAS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_sofa", () -> PlatformBridges.get().getBlockFactory().createSofa(BlockVariant.wool(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_PLANKS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_planks", () -> PlatformBridges.get().getBlockFactory().createPaintedPlanks(BlockVariant.OAK.createSettings().mapColor(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_SLABS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_wood_slab", () -> PlatformBridges.get().getBlockFactory().createPaintedWoodSlab(BlockVariant.OAK.createSettings().mapColor(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_STAIRS = BLOCKS.registerBy(DyeColor.values(), color -> {
        Registered<Block> planks = PAINTED_PLANKS.get((DyeColor)color);
        return HELPER.registerBlock(color.getSerializedName() + "_wood_stairs", () -> PlatformBridges.get().getBlockFactory().createPaintedWoodStairs(((Block)planks.get()).defaultBlockState(), BlockVariant.OAK.createSettings().mapColor(color)));
    });
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_FENCES = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_wood_fence", () -> PlatformBridges.get().getBlockFactory().createPaintedWoodFence(BlockVariant.OAK.createSettings().mapColor(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_FENCE_GATES = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_wood_fence_gate", () -> PlatformBridges.get().getBlockFactory().createPaintedWoodFenceGate(AdornWoodTypes.PAINTED_WOODS.get(color), BlockVariant.OAK.createSettings().mapColor(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_PRESSURE_PLATES = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_wood_pressure_plate", () -> new PressurePlateBlock((BlockSetType)AdornBlockSetTypes.PAINTED_WOODS.get(color), BlockVariant.OAK.createSettings().mapColor(color))));
    public static final RegisteredMap<DyeColor, Block> PAINTED_WOOD_BUTTONS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_wood_button", () -> Blocks.woodenButton((BlockSetType)((BlockSetType)AdornBlockSetTypes.PAINTED_WOODS.get(color)))));
    public static final Registered<Block> BRICK_CHIMNEY = HELPER.registerBlock("brick_chimney", () -> new ChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.COLOR_RED)));
    public static final Registered<Block> STONE_BRICK_CHIMNEY = HELPER.registerBlock("stone_brick_chimney", () -> new ChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.STONE)));
    public static final Registered<Block> NETHER_BRICK_CHIMNEY = HELPER.registerBlock("nether_brick_chimney", () -> new ChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.NETHER)));
    public static final Registered<Block> RED_NETHER_BRICK_CHIMNEY = HELPER.registerBlock("red_nether_brick_chimney", () -> new ChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.NETHER)));
    public static final Registered<Block> COBBLESTONE_CHIMNEY = HELPER.registerBlock("cobblestone_chimney", () -> new ChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.STONE)));
    public static final Registered<Block> PRISMARINE_CHIMNEY = HELPER.registerBlock("prismarine_chimney", () -> new PrismarineChimneyBlock(AbstractChimneyBlock.createBlockSettings(MapColor.COLOR_CYAN, 1.5f)));
    public static final Registered<Block> MAGMATIC_PRISMARINE_CHIMNEY = HELPER.registerBlock("magmatic_prismarine_chimney", () -> new PrismarineChimneyBlock.WithColumn(true, AbstractChimneyBlock.createBlockSettings(MapColor.COLOR_CYAN, 1.5f).lightLevel(state -> 3)));
    public static final Registered<Block> SOULFUL_PRISMARINE_CHIMNEY = HELPER.registerBlock("soulful_prismarine_chimney", () -> new PrismarineChimneyBlock.WithColumn(false, AbstractChimneyBlock.createBlockSettings(MapColor.COLOR_CYAN, 1.5f)));
    public static final RegisteredMap<DyeColor, Block> TABLE_LAMPS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_table_lamp", () -> new TableLampBlock(TableLampBlock.createBlockSettings(color))));
    public static final Registered<Block> TRADING_STATION = HELPER.registerBlock("trading_station", block -> new TradingStationItem((Block)block, new Item.Properties()), () -> new TradingStationBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(2.5f).sound(SoundType.WOOD)));
    public static final Registered<Block> STONE_TORCH_GROUND = HELPER.registerBlockWithoutItem("stone_torch", () -> new TorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).sound(SoundType.STONE).lightLevel(state -> 15)));
    public static final Registered<Block> STONE_TORCH_WALL = HELPER.registerBlockWithoutItem("wall_stone_torch", () -> new WallTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)STONE_TORCH_GROUND.get())).dropsLike((Block)STONE_TORCH_GROUND.get())));
    public static final Registered<Block> CRATE = HELPER.registerBlock("crate", () -> new Block(AdornUtil.copySettingsSafely(Blocks.OAK_PLANKS)));
    public static final Registered<Block> APPLE_CRATE = AdornBlocks.registerCrate("apple_crate");
    public static final Registered<Block> WHEAT_CRATE = AdornBlocks.registerCrate("wheat_crate");
    public static final Registered<Block> CARROT_CRATE = AdornBlocks.registerCrate("carrot_crate");
    public static final Registered<Block> POTATO_CRATE = AdornBlocks.registerCrate("potato_crate");
    public static final Registered<Block> MELON_CRATE = AdornBlocks.registerCrate("melon_crate");
    public static final Registered<Block> WHEAT_SEED_CRATE = AdornBlocks.registerCrate("wheat_seed_crate");
    public static final Registered<Block> MELON_SEED_CRATE = AdornBlocks.registerCrate("melon_seed_crate");
    public static final Registered<Block> PUMPKIN_SEED_CRATE = AdornBlocks.registerCrate("pumpkin_seed_crate");
    public static final Registered<Block> BEETROOT_CRATE = AdornBlocks.registerCrate("beetroot_crate");
    public static final Registered<Block> BEETROOT_SEED_CRATE = AdornBlocks.registerCrate("beetroot_seed_crate");
    public static final Registered<Block> SWEET_BERRY_CRATE = AdornBlocks.registerCrate("sweet_berry_crate");
    public static final Registered<Block> COCOA_BEAN_CRATE = AdornBlocks.registerCrate("cocoa_bean_crate");
    public static final Registered<Block> NETHER_WART_CRATE = AdornBlocks.registerCrate("nether_wart_crate");
    public static final Registered<Block> SUGAR_CANE_CRATE = AdornBlocks.registerCrate("sugar_cane_crate");
    public static final Registered<Block> EGG_CRATE = AdornBlocks.registerCrate("egg_crate");
    public static final Registered<Block> HONEYCOMB_CRATE = AdornBlocks.registerCrate("honeycomb_crate");
    public static final Registered<Block> LIL_TATER_CRATE = AdornBlocks.registerCrate("lil_tater_crate");
    public static final Registered<Block> PICKET_FENCE = HELPER.registerBlock("picket_fence", () -> new PicketFenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).noOcclusion()));
    public static final Registered<Block> CHAIN_LINK_FENCE = HELPER.registerBlock("chain_link_fence", () -> new ChainLinkFenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).sound(AdornSounds.CHAIN_LINK_FENCE)));
    public static final Registered<Block> STONE_LADDER = HELPER.registerBlock("stone_ladder", () -> new StoneLadderBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion()));
    public static final Registered<Block> BREWER = HELPER.registerBlock("brewer", () -> new BrewerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).forceSolidOn().strength(0.8f).requiresCorrectToolForDrops()));
    public static final Registered<Block> CANDLELIT_LANTERN = HELPER.registerBlock("candlelit_lantern", () -> new CandlelitLanternBlock(CandlelitLanternBlock.createBlockSettings()));
    public static final RegisteredMap<DyeColor, Block> DYED_CANDLELIT_LANTERNS = BLOCKS.registerBy(DyeColor.values(), color -> HELPER.registerBlock(color.getSerializedName() + "_candlelit_lantern", () -> new CandlelitLanternBlock(CandlelitLanternBlock.createBlockSettings())));
    public static final Registered<Block> COPPER_PIPE = HELPER.registerBlock("copper_pipe", () -> new OxidizableCopperPipeBlock(WeatheringCopper.WeatherState.UNAFFECTED, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 5.0f).sound(SoundType.COPPER).mapColor(MapColor.COLOR_ORANGE)));
    public static final Registered<Block> EXPOSED_COPPER_PIPE = HELPER.registerBlock("exposed_copper_pipe", () -> new OxidizableCopperPipeBlock(WeatheringCopper.WeatherState.EXPOSED, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 5.0f).sound(SoundType.COPPER).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)));
    public static final Registered<Block> WEATHERED_COPPER_PIPE = HELPER.registerBlock("weathered_copper_pipe", () -> new OxidizableCopperPipeBlock(WeatheringCopper.WeatherState.WEATHERED, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 5.0f).sound(SoundType.COPPER).mapColor(MapColor.WARPED_STEM)));
    public static final Registered<Block> OXIDIZED_COPPER_PIPE = HELPER.registerBlock("oxidized_copper_pipe", () -> new OxidizableCopperPipeBlock(WeatheringCopper.WeatherState.OXIDIZED, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 5.0f).sound(SoundType.COPPER).mapColor(MapColor.WARPED_NYLIUM)));
    public static final Registered<Block> WAXED_COPPER_PIPE = HELPER.registerBlock("waxed_copper_pipe", () -> new CopperPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COPPER_PIPE.get()))));
    public static final Registered<Block> WAXED_EXPOSED_COPPER_PIPE = HELPER.registerBlock("waxed_exposed_copper_pipe", () -> new CopperPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)EXPOSED_COPPER_PIPE.get()))));
    public static final Registered<Block> WAXED_WEATHERED_COPPER_PIPE = HELPER.registerBlock("waxed_weathered_copper_pipe", () -> new CopperPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)WEATHERED_COPPER_PIPE.get()))));
    public static final Registered<Block> WAXED_OXIDIZED_COPPER_PIPE = HELPER.registerBlock("waxed_oxidized_copper_pipe", () -> new CopperPipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OXIDIZED_COPPER_PIPE.get()))));

    public static void init() {
    }

    private static Registered<Block> registerCrate(String name) {
        return HELPER.registerBlock(name, () -> new Item.Properties().craftRemainder(((Block)CRATE.get()).asItem()), () -> new Block(AdornUtil.copySettingsSafely((Block)CRATE.get())));
    }
}

