/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn;

import juuxel.adorn.block.CarpetedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class CommonEventHandlers {
    public static InteractionResult handleCarpets(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        BlockItem blockItem;
        Block block;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof WoolCarpetBlock) {
            CarpetedBlock carpeted;
            WoolCarpetBlock carpet = (WoolCarpetBlock)block;
            BlockPos pos = hit.getBlockPos().relative(hit.getDirection());
            BlockState state = world.getBlockState(pos);
            Block block2 = state.getBlock();
            if (block2 instanceof CarpetedBlock && (carpeted = (CarpetedBlock)block2).canStateBeCarpeted(state)) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(CarpetedBlock.CARPET, CarpetedBlock.CARPET.wrapOrNone(carpet.getColor())));
                SoundType soundGroup = carpet.defaultBlockState().getSoundType();
                world.playSound(player, pos, soundGroup.getPlaceSound(), SoundSource.BLOCKS, (soundGroup.volume + 1.0f) * 0.5f, soundGroup.pitch * 0.8f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                player.swing(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

