/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.locators.NeoForgeDevProvider;
import net.neoforged.fml.loading.moddiscovery.locators.UserdevLocator;
import net.neoforged.fml.loading.targets.ArgumentList;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public abstract class CommonDevLaunchHandler
extends CommonLaunchHandler {
    @Override
    public boolean isProduction() {
        return false;
    }

    @Override
    public void collectAdditionalModFileLocators(VersionInfo versionInfo, Consumer<IModFileCandidateLocator> output) {
        super.collectAdditionalModFileLocators(versionInfo, output);
        Map<String, List<Path>> groupedModFolders = CommonDevLaunchHandler.getGroupedModFolders();
        List<Path> minecraftFolders = groupedModFolders.get("minecraft");
        if (minecraftFolders == null) {
            throw new IllegalStateException("Expected paths to minecraft classes to be passed via environment");
        }
        output.accept(new NeoForgeDevProvider(minecraftFolders));
        output.accept(new UserdevLocator(groupedModFolders));
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        super.preLaunch(arguments, layer);
        if (this.getDist().isDedicatedServer()) {
            return arguments;
        }
        if (this.isData()) {
            return arguments;
        }
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuffer replaced = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(replaced, CommonDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return args.getArguments();
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }
}

