/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class LightEngine<M extends DataLayerStorageMap<M>, S extends LayerLightSectionStorage<M>>
implements LayerLightEventListener {
    public static final int MAX_LEVEL = 15;
    protected static final int MIN_OPACITY = 1;
    protected static final long PULL_LIGHT_IN_ENTRY = QueueEntry.decreaseAllDirections(1);
    private static final int MIN_QUEUE_SIZE = 512;
    protected static final Direction[] PROPAGATION_DIRECTIONS = Direction.values();
    protected final LightChunkGetter chunkSource;
    protected final S storage;
    private final LongOpenHashSet blockNodesToCheck = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue decreaseQueue = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue increaseQueue = new LongArrayFIFOQueue();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private static final int CACHE_SIZE = 2;
    private final long[] lastChunkPos = new long[2];
    private final LightChunk[] lastChunk = new LightChunk[2];

    protected LightEngine(LightChunkGetter p_285189_, S p_284964_) {
        this.chunkSource = p_285189_;
        this.storage = p_284964_;
        this.clearChunkCache();
    }

    public static boolean hasDifferentLightProperties(BlockGetter p_285159_, BlockPos p_284985_, BlockState p_285110_, BlockState p_285372_) {
        if (p_285372_ == p_285110_) {
            return false;
        }
        return p_285372_.getLightBlock(p_285159_, p_284985_) != p_285110_.getLightBlock(p_285159_, p_284985_) || p_285372_.getLightEmission() != p_285110_.getLightEmission() || p_285372_.useShapeForLightOcclusion() || p_285110_.useShapeForLightOcclusion();
    }

    public static int getLightBlockInto(BlockGetter p_285330_, BlockState p_285453_, BlockPos p_285187_, BlockState p_285318_, BlockPos p_285240_, Direction p_285196_, int p_285248_) {
        VoxelShape $$10;
        boolean $$7 = LightEngine.isEmptyShape(p_285453_);
        boolean $$8 = LightEngine.isEmptyShape(p_285318_);
        if ($$7 && $$8) {
            return p_285248_;
        }
        VoxelShape $$9 = $$7 ? Shapes.empty() : p_285453_.getOcclusionShape(p_285330_, p_285187_);
        VoxelShape voxelShape = $$10 = $$8 ? Shapes.empty() : p_285318_.getOcclusionShape(p_285330_, p_285240_);
        if (Shapes.mergedFaceOccludes($$9, $$10, p_285196_)) {
            return 16;
        }
        return p_285248_;
    }

    public static VoxelShape getOcclusionShape(BlockGetter p_285472_, BlockPos p_285229_, BlockState p_285020_, Direction p_285455_) {
        return LightEngine.isEmptyShape(p_285020_) ? Shapes.empty() : p_285020_.getFaceOcclusionShape(p_285472_, p_285229_, p_285455_);
    }

    protected static boolean isEmptyShape(BlockState p_285133_) {
        return !p_285133_.canOcclude() || !p_285133_.useShapeForLightOcclusion();
    }

    protected BlockState getState(BlockPos p_285338_) {
        int $$2;
        int $$1 = SectionPos.blockToSectionCoord(p_285338_.getX());
        LightChunk $$3 = this.getChunk($$1, $$2 = SectionPos.blockToSectionCoord(p_285338_.getZ()));
        if ($$3 == null) {
            return Blocks.BEDROCK.defaultBlockState();
        }
        return $$3.getBlockState(p_285338_);
    }

    protected int getOpacity(BlockState p_285084_, BlockPos p_285057_) {
        return Math.max(1, p_285084_.getLightBlock(this.chunkSource.getLevel(), p_285057_));
    }

    protected boolean shapeOccludes(long p_285115_, BlockState p_285154_, long p_284957_, BlockState p_285155_, Direction p_285327_) {
        VoxelShape $$5 = this.getOcclusionShape(p_285154_, p_285115_, p_285327_);
        VoxelShape $$6 = this.getOcclusionShape(p_285155_, p_284957_, p_285327_.getOpposite());
        return Shapes.faceShapeOccludes($$5, $$6);
    }

    protected VoxelShape getOcclusionShape(BlockState p_285136_, long p_285517_, Direction p_285376_) {
        return LightEngine.getOcclusionShape(this.chunkSource.getLevel(), this.mutablePos.set(p_285517_), p_285136_, p_285376_);
    }

    @Nullable
    protected LightChunk getChunk(int p_284967_, int p_285447_) {
        long $$2 = ChunkPos.asLong(p_284967_, p_285447_);
        for (int $$3 = 0; $$3 < 2; ++$$3) {
            if ($$2 != this.lastChunkPos[$$3]) continue;
            return this.lastChunk[$$3];
        }
        LightChunk $$4 = this.chunkSource.getChunkForLighting(p_284967_, p_285447_);
        for (int $$5 = 1; $$5 > 0; --$$5) {
            this.lastChunkPos[$$5] = this.lastChunkPos[$$5 - 1];
            this.lastChunk[$$5] = this.lastChunk[$$5 - 1];
        }
        this.lastChunkPos[0] = $$2;
        this.lastChunk[0] = $$4;
        return $$4;
    }

    private void clearChunkCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunk, null);
    }

    @Override
    public void checkBlock(BlockPos p_285352_) {
        this.blockNodesToCheck.add(p_285352_.asLong());
    }

    public void queueSectionData(long p_285221_, @Nullable DataLayer p_285427_) {
        ((LayerLightSectionStorage)this.storage).queueSectionData(p_285221_, p_285427_);
    }

    public void retainData(ChunkPos p_285314_, boolean p_284937_) {
        ((LayerLightSectionStorage)this.storage).retainData(SectionPos.getZeroNode(p_285314_.x, p_285314_.z), p_284937_);
    }

    @Override
    public void updateSectionStatus(SectionPos p_285167_, boolean p_284934_) {
        ((LayerLightSectionStorage)this.storage).updateSectionStatus(p_285167_.asLong(), p_284934_);
    }

    @Override
    public void setLightEnabled(ChunkPos p_285116_, boolean p_285522_) {
        ((LayerLightSectionStorage)this.storage).setLightEnabled(SectionPos.getZeroNode(p_285116_.x, p_285116_.z), p_285522_);
    }

    @Override
    public int runLightUpdates() {
        LongIterator $$0 = this.blockNodesToCheck.iterator();
        while ($$0.hasNext()) {
            this.checkNode($$0.nextLong());
        }
        this.blockNodesToCheck.clear();
        this.blockNodesToCheck.trim(512);
        int $$1 = 0;
        $$1 += this.propagateDecreases();
        this.clearChunkCache();
        ((LayerLightSectionStorage)this.storage).markNewInconsistencies(this);
        ((LayerLightSectionStorage)this.storage).swapSectionMap();
        return $$1 += this.propagateIncreases();
    }

    private int propagateIncreases() {
        int $$0 = 0;
        while (!this.increaseQueue.isEmpty()) {
            long $$1 = this.increaseQueue.dequeueLong();
            long $$2 = this.increaseQueue.dequeueLong();
            int $$3 = ((LayerLightSectionStorage)this.storage).getStoredLevel($$1);
            int $$4 = QueueEntry.getFromLevel($$2);
            if (QueueEntry.isIncreaseFromEmission($$2) && $$3 < $$4) {
                ((LayerLightSectionStorage)this.storage).setStoredLevel($$1, $$4);
                $$3 = $$4;
            }
            if ($$3 == $$4) {
                this.propagateIncrease($$1, $$2, $$3);
            }
            ++$$0;
        }
        return $$0;
    }

    private int propagateDecreases() {
        int $$0 = 0;
        while (!this.decreaseQueue.isEmpty()) {
            long $$1 = this.decreaseQueue.dequeueLong();
            long $$2 = this.decreaseQueue.dequeueLong();
            this.propagateDecrease($$1, $$2);
            ++$$0;
        }
        return $$0;
    }

    protected void enqueueDecrease(long p_285228_, long p_285464_) {
        this.decreaseQueue.enqueue(p_285228_);
        this.decreaseQueue.enqueue(p_285464_);
    }

    protected void enqueueIncrease(long p_285223_, long p_285022_) {
        this.increaseQueue.enqueue(p_285223_);
        this.increaseQueue.enqueue(p_285022_);
    }

    @Override
    public boolean hasLightWork() {
        return ((LayerLightSectionStorage)this.storage).hasInconsistencies() || !this.blockNodesToCheck.isEmpty() || !this.decreaseQueue.isEmpty() || !this.increaseQueue.isEmpty();
    }

    @Override
    @Nullable
    public DataLayer getDataLayerData(SectionPos p_285093_) {
        return ((LayerLightSectionStorage)this.storage).getDataLayerData(p_285093_.asLong());
    }

    @Override
    public int getLightValue(BlockPos p_285149_) {
        return ((LayerLightSectionStorage)this.storage).getLightValue(p_285149_.asLong());
    }

    public String getDebugData(long p_285363_) {
        return this.getDebugSectionType(p_285363_).display();
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(long p_285320_) {
        return ((LayerLightSectionStorage)this.storage).getDebugSectionType(p_285320_);
    }

    protected abstract void checkNode(long var1);

    protected abstract void propagateIncrease(long var1, long var3, int var5);

    protected abstract void propagateDecrease(long var1, long var3);

    public static class QueueEntry {
        private static final int FROM_LEVEL_BITS = 4;
        private static final int DIRECTION_BITS = 6;
        private static final long LEVEL_MASK = 15L;
        private static final long DIRECTIONS_MASK = 1008L;
        private static final long FLAG_FROM_EMPTY_SHAPE = 1024L;
        private static final long FLAG_INCREASE_FROM_EMISSION = 2048L;

        public static long decreaseSkipOneDirection(int p_285429_, Direction p_285207_) {
            long $$2 = QueueEntry.withoutDirection(1008L, p_285207_);
            return QueueEntry.withLevel($$2, p_285429_);
        }

        public static long decreaseAllDirections(int p_285144_) {
            return QueueEntry.withLevel(1008L, p_285144_);
        }

        public static long increaseLightFromEmission(int p_285199_, boolean p_284986_) {
            long $$2 = 1008L;
            $$2 |= 0x800L;
            if (p_284986_) {
                $$2 |= 0x400L;
            }
            return QueueEntry.withLevel($$2, p_285199_);
        }

        public static long increaseSkipOneDirection(int p_285091_, boolean p_285186_, Direction p_285382_) {
            long $$3 = QueueEntry.withoutDirection(1008L, p_285382_);
            if (p_285186_) {
                $$3 |= 0x400L;
            }
            return QueueEntry.withLevel($$3, p_285091_);
        }

        public static long increaseOnlyOneDirection(int p_285025_, boolean p_285384_, Direction p_285072_) {
            long $$3 = 0L;
            if (p_285384_) {
                $$3 |= 0x400L;
            }
            $$3 = QueueEntry.withDirection($$3, p_285072_);
            return QueueEntry.withLevel($$3, p_285025_);
        }

        public static long increaseSkySourceInDirections(boolean p_285487_, boolean p_285390_, boolean p_285476_, boolean p_285505_, boolean p_285127_) {
            long $$5 = QueueEntry.withLevel(0L, 15);
            if (p_285487_) {
                $$5 = QueueEntry.withDirection($$5, Direction.DOWN);
            }
            if (p_285390_) {
                $$5 = QueueEntry.withDirection($$5, Direction.NORTH);
            }
            if (p_285476_) {
                $$5 = QueueEntry.withDirection($$5, Direction.SOUTH);
            }
            if (p_285505_) {
                $$5 = QueueEntry.withDirection($$5, Direction.WEST);
            }
            if (p_285127_) {
                $$5 = QueueEntry.withDirection($$5, Direction.EAST);
            }
            return $$5;
        }

        public static int getFromLevel(long p_285483_) {
            return (int)(p_285483_ & 0xFL);
        }

        public static boolean isFromEmptyShape(long p_285436_) {
            return (p_285436_ & 0x400L) != 0L;
        }

        public static boolean isIncreaseFromEmission(long p_285348_) {
            return (p_285348_ & 0x800L) != 0L;
        }

        public static boolean shouldPropagateInDirection(long p_285347_, Direction p_285291_) {
            return (p_285347_ & 1L << p_285291_.ordinal() + 4) != 0L;
        }

        private static long withLevel(long p_285234_, int p_285042_) {
            return p_285234_ & 0xFFFFFFFFFFFFFFF0L | (long)p_285042_ & 0xFL;
        }

        private static long withDirection(long p_285295_, Direction p_285016_) {
            return p_285295_ | 1L << p_285016_.ordinal() + 4;
        }

        private static long withoutDirection(long p_285366_, Direction p_285489_) {
            return p_285366_ & (1L << p_285489_.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

