/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.PlayerTeam;

public class SpreadPlayersCommand {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((p_304299_, p_304300_, p_304301_, p_304302_) -> Component.translatableEscape("commands.spreadplayers.failed.teams", p_304299_, p_304300_, p_304301_, p_304302_));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((p_304305_, p_304306_, p_304307_, p_304308_) -> Component.translatableEscape("commands.spreadplayers.failed.entities", p_304305_, p_304306_, p_304307_, p_304308_));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((p_304303_, p_304304_) -> Component.translatableEscape("commands.spreadplayers.failed.invalid.height", p_304303_, p_304304_));

    public static void register(CommandDispatcher<CommandSourceStack> p_138697_) {
        p_138697_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spreadplayers").requires(p_201852_ -> p_201852_.hasPermission(2))).then(Commands.argument("center", Vec2Argument.vec2()).then(Commands.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(p_340666_ -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)p_340666_.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)p_340666_, "center"), FloatArgumentType.getFloat((CommandContext)p_340666_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_340666_, (String)"maxRange"), ((CommandSourceStack)p_340666_.getSource()).getLevel().getMaxBuildHeight(), BoolArgumentType.getBool((CommandContext)p_340666_, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_340666_, "targets")))))).then(Commands.literal("under").then(Commands.argument("maxHeight", IntegerArgumentType.integer()).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(p_201850_ -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)p_201850_.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)p_201850_, "center"), FloatArgumentType.getFloat((CommandContext)p_201850_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_201850_, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)p_201850_, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)p_201850_, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_201850_, "targets")))))))))));
    }

    private static int spreadPlayers(CommandSourceStack p_138703_, Vec2 p_138704_, float p_138705_, float p_138706_, int p_138707_, boolean p_138708_, Collection<? extends Entity> p_138709_) throws CommandSyntaxException {
        ServerLevel $$7 = p_138703_.getLevel();
        int $$8 = $$7.getMinBuildHeight();
        if (p_138707_ < $$8) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)p_138707_, (Object)$$8);
        }
        RandomSource $$9 = RandomSource.create();
        double $$10 = p_138704_.x - p_138706_;
        double $$11 = p_138704_.y - p_138706_;
        double $$12 = p_138704_.x + p_138706_;
        double $$13 = p_138704_.y + p_138706_;
        Position[] $$14 = SpreadPlayersCommand.createInitialPositions($$9, p_138708_ ? SpreadPlayersCommand.getNumberOfTeams(p_138709_) : p_138709_.size(), $$10, $$11, $$12, $$13);
        SpreadPlayersCommand.spreadPositions(p_138704_, p_138705_, $$7, $$9, $$10, $$11, $$12, $$13, p_138707_, $$14, p_138708_);
        double $$15 = SpreadPlayersCommand.setPlayerPositions(p_138709_, $$7, $$14, p_138707_, p_138708_);
        p_138703_.sendSuccess(() -> Component.translatable("commands.spreadplayers.success." + (p_138708_ ? "teams" : "entities"), $$14.length, Float.valueOf(p_288625_.x), Float.valueOf(p_288625_.y), String.format(Locale.ROOT, "%.2f", $$15)), true);
        return $$14.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> p_138728_) {
        HashSet $$1 = Sets.newHashSet();
        for (Entity entity : p_138728_) {
            if (entity instanceof Player) {
                $$1.add(entity.getTeam());
                continue;
            }
            $$1.add(null);
        }
        return $$1.size();
    }

    private static void spreadPositions(Vec2 p_214741_, double p_214742_, ServerLevel p_214743_, RandomSource p_214744_, double p_214745_, double p_214746_, double p_214747_, double p_214748_, int p_214749_, Position[] p_214750_, boolean p_214751_) throws CommandSyntaxException {
        int $$13;
        boolean $$11 = true;
        double $$12 = 3.4028234663852886E38;
        for ($$13 = 0; $$13 < 10000 && $$11; ++$$13) {
            $$11 = false;
            $$12 = 3.4028234663852886E38;
            for (int $$14 = 0; $$14 < p_214750_.length; ++$$14) {
                Position $$15 = p_214750_[$$14];
                int $$16 = 0;
                Position $$17 = new Position();
                for (int $$18 = 0; $$18 < p_214750_.length; ++$$18) {
                    if ($$14 == $$18) continue;
                    Position $$19 = p_214750_[$$18];
                    double $$20 = $$15.dist($$19);
                    $$12 = Math.min($$20, $$12);
                    if (!($$20 < p_214742_)) continue;
                    ++$$16;
                    $$17.x += $$19.x - $$15.x;
                    $$17.z += $$19.z - $$15.z;
                }
                if ($$16 > 0) {
                    $$17.x /= (double)$$16;
                    $$17.z /= (double)$$16;
                    double $$21 = $$17.getLength();
                    if ($$21 > 0.0) {
                        $$17.normalize();
                        $$15.moveAway($$17);
                    } else {
                        $$15.randomize(p_214744_, p_214745_, p_214746_, p_214747_, p_214748_);
                    }
                    $$11 = true;
                }
                if (!$$15.clamp(p_214745_, p_214746_, p_214747_, p_214748_)) continue;
                $$11 = true;
            }
            if ($$11) continue;
            for (Position $$22 : p_214750_) {
                if ($$22.isSafe(p_214743_, p_214749_)) continue;
                $$22.randomize(p_214744_, p_214745_, p_214746_, p_214747_, p_214748_);
                $$11 = true;
            }
        }
        if ($$12 == 3.4028234663852886E38) {
            $$12 = 0.0;
        }
        if ($$13 >= 10000) {
            if (p_214751_) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)p_214750_.length, (Object)Float.valueOf(p_214741_.x), (Object)Float.valueOf(p_214741_.y), (Object)String.format(Locale.ROOT, "%.2f", $$12));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)p_214750_.length, (Object)Float.valueOf(p_214741_.x), (Object)Float.valueOf(p_214741_.y), (Object)String.format(Locale.ROOT, "%.2f", $$12));
        }
    }

    private static double setPlayerPositions(Collection<? extends Entity> p_138730_, ServerLevel p_138731_, Position[] p_138732_, int p_138733_, boolean p_138734_) {
        double $$5 = 0.0;
        int $$6 = 0;
        HashMap $$7 = Maps.newHashMap();
        for (Entity entity : p_138730_) {
            Position $$11;
            if (p_138734_) {
                PlayerTeam $$9;
                PlayerTeam playerTeam = $$9 = entity instanceof Player ? entity.getTeam() : null;
                if (!$$7.containsKey($$9)) {
                    $$7.put($$9, p_138732_[$$6++]);
                }
                Position $$10 = (Position)$$7.get($$9);
            } else {
                $$11 = p_138732_[$$6++];
            }
            entity.teleportTo(p_138731_, (double)Mth.floor($$11.x) + 0.5, $$11.getSpawnY(p_138731_, p_138733_), (double)Mth.floor($$11.z) + 0.5, Set.of(), entity.getYRot(), entity.getXRot());
            double $$12 = Double.MAX_VALUE;
            for (Position $$13 : p_138732_) {
                if ($$11 == $$13) continue;
                double $$14 = $$11.dist($$13);
                $$12 = Math.min($$14, $$12);
            }
            $$5 += $$12;
        }
        if (p_138730_.size() < 2) {
            return 0.0;
        }
        return $$5 /= (double)p_138730_.size();
    }

    private static Position[] createInitialPositions(RandomSource p_214734_, int p_214735_, double p_214736_, double p_214737_, double p_214738_, double p_214739_) {
        Position[] $$6 = new Position[p_214735_];
        for (int $$7 = 0; $$7 < $$6.length; ++$$7) {
            Position $$8 = new Position();
            $$8.randomize(p_214734_, p_214736_, p_214737_, p_214738_, p_214739_);
            $$6[$$7] = $$8;
        }
        return $$6;
    }

    static class Position {
        double x;
        double z;

        Position() {
        }

        double dist(Position p_138768_) {
            double $$1 = this.x - p_138768_.x;
            double $$2 = this.z - p_138768_.z;
            return Math.sqrt($$1 * $$1 + $$2 * $$2);
        }

        void normalize() {
            double $$0 = this.getLength();
            this.x /= $$0;
            this.z /= $$0;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position p_138777_) {
            this.x -= p_138777_.x;
            this.z -= p_138777_.z;
        }

        public boolean clamp(double p_138754_, double p_138755_, double p_138756_, double p_138757_) {
            boolean $$4 = false;
            if (this.x < p_138754_) {
                this.x = p_138754_;
                $$4 = true;
            } else if (this.x > p_138756_) {
                this.x = p_138756_;
                $$4 = true;
            }
            if (this.z < p_138755_) {
                this.z = p_138755_;
                $$4 = true;
            } else if (this.z > p_138757_) {
                this.z = p_138757_;
                $$4 = true;
            }
            return $$4;
        }

        public int getSpawnY(BlockGetter p_138759_, int p_138760_) {
            BlockPos.MutableBlockPos $$2 = new BlockPos.MutableBlockPos(this.x, (double)(p_138760_ + 1), this.z);
            boolean $$3 = p_138759_.getBlockState($$2).isAir();
            $$2.move(Direction.DOWN);
            boolean $$4 = p_138759_.getBlockState($$2).isAir();
            while ($$2.getY() > p_138759_.getMinBuildHeight()) {
                $$2.move(Direction.DOWN);
                boolean $$5 = p_138759_.getBlockState($$2).isAir();
                if (!$$5 && $$4 && $$3) {
                    return $$2.getY() + 1;
                }
                $$3 = $$4;
                $$4 = $$5;
            }
            return p_138760_ + 1;
        }

        public boolean isSafe(BlockGetter p_138774_, int p_138775_) {
            BlockPos $$2 = BlockPos.containing(this.x, this.getSpawnY(p_138774_, p_138775_) - 1, this.z);
            BlockState $$3 = p_138774_.getBlockState($$2);
            return $$2.getY() < p_138775_ && !$$3.liquid() && !$$3.is(BlockTags.FIRE);
        }

        public void randomize(RandomSource p_214753_, double p_214754_, double p_214755_, double p_214756_, double p_214757_) {
            this.x = Mth.nextDouble(p_214753_, p_214754_, p_214756_);
            this.z = Mth.nextDouble(p_214753_, p_214755_, p_214757_);
        }
    }
}

