/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.language.FormattedBidiReorder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import org.slf4j.Logger;

public class ClientLanguage
extends Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, String> storage;
    private final boolean defaultRightToLeft;

    private ClientLanguage(Map<String, String> p_118914_, boolean p_118915_) {
        this.storage = p_118914_;
        this.defaultRightToLeft = p_118915_;
    }

    public static ClientLanguage loadFrom(ResourceManager p_265765_, List<String> p_265743_, boolean p_265470_) {
        HashMap $$3 = Maps.newHashMap();
        for (String $$4 : p_265743_) {
            String $$5 = String.format(Locale.ROOT, "lang/%s.json", $$4);
            for (String $$6 : p_265765_.getNamespaces()) {
                try {
                    ResourceLocation $$7 = ResourceLocation.fromNamespaceAndPath($$6, $$5);
                    ClientLanguage.appendFrom($$4, p_265765_.getResourceStack($$7), $$3);
                }
                catch (Exception $$8) {
                    LOGGER.warn("Skipped language file: {}:{} ({})", new Object[]{$$6, $$5, $$8.toString()});
                }
            }
        }
        return new ClientLanguage((Map<String, String>)ImmutableMap.copyOf((Map)$$3), p_265470_);
    }

    private static void appendFrom(String p_235036_, List<Resource> p_235037_, Map<String, String> p_235038_) {
        for (Resource $$3 : p_235037_) {
            try {
                InputStream $$4 = $$3.open();
                try {
                    Language.loadFromJson($$4, p_235038_::put);
                }
                finally {
                    if ($$4 == null) continue;
                    $$4.close();
                }
            }
            catch (IOException $$5) {
                LOGGER.warn("Failed to load translations for {} from pack {}", new Object[]{p_235036_, $$3.sourcePackId(), $$5});
            }
        }
    }

    @Override
    public String getOrDefault(String p_118920_, String p_265273_) {
        return this.storage.getOrDefault(p_118920_, p_265273_);
    }

    @Override
    public boolean has(String p_118928_) {
        return this.storage.containsKey(p_118928_);
    }

    @Override
    public boolean isDefaultRightToLeft() {
        return this.defaultRightToLeft;
    }

    @Override
    public FormattedCharSequence getVisualOrder(FormattedText p_118925_) {
        return FormattedBidiReorder.reorder(p_118925_, this.defaultRightToLeft);
    }
}

