/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.ShulkerHeadLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShulkerRenderer
extends MobRenderer<Shulker, ShulkerModel<Shulker>> {
    private static final ResourceLocation DEFAULT_TEXTURE_LOCATION = Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION.texture().withPath(p_349906_ -> "textures/" + p_349906_ + ".png");
    private static final ResourceLocation[] TEXTURE_LOCATION = (ResourceLocation[])Sheets.SHULKER_TEXTURE_LOCATION.stream().map(p_349907_ -> p_349907_.texture().withPath(p_349905_ -> "textures/" + p_349905_ + ".png")).toArray(ResourceLocation[]::new);

    public ShulkerRenderer(EntityRendererProvider.Context p_174370_) {
        super(p_174370_, new ShulkerModel(p_174370_.bakeLayer(ModelLayers.SHULKER)), 0.0f);
        this.addLayer(new ShulkerHeadLayer(this));
    }

    @Override
    public Vec3 getRenderOffset(Shulker p_115904_, float p_115905_) {
        return p_115904_.getRenderPosition(p_115905_).orElse(super.getRenderOffset(p_115904_, p_115905_)).scale(p_115904_.getScale());
    }

    @Override
    public boolean shouldRender(Shulker p_115913_, Frustum p_115914_, double p_115915_, double p_115916_, double p_115917_) {
        if (super.shouldRender(p_115913_, p_115914_, p_115915_, p_115916_, p_115917_)) {
            return true;
        }
        return p_115913_.getRenderPosition(0.0f).filter(p_174374_ -> {
            EntityType<?> $$3 = p_115913_.getType();
            float $$4 = $$3.getHeight() / 2.0f;
            float $$5 = $$3.getWidth() / 2.0f;
            Vec3 $$6 = Vec3.atBottomCenterOf(p_115913_.blockPosition());
            return p_115914_.isVisible(new AABB(p_174374_.x, p_174374_.y + (double)$$4, p_174374_.z, $$6.x, $$6.y + (double)$$4, $$6.z).inflate($$5, $$4, $$5));
        }).isPresent();
    }

    @Override
    public ResourceLocation getTextureLocation(Shulker p_115902_) {
        return ShulkerRenderer.getTextureLocation(p_115902_.getColor());
    }

    public static ResourceLocation getTextureLocation(@Nullable DyeColor p_174376_) {
        if (p_174376_ == null) {
            return DEFAULT_TEXTURE_LOCATION;
        }
        return TEXTURE_LOCATION[p_174376_.getId()];
    }

    @Override
    protected void setupRotations(Shulker p_320913_, PoseStack p_115891_, float p_115892_, float p_115893_, float p_115894_, float p_319950_) {
        super.setupRotations(p_320913_, p_115891_, p_115892_, p_115893_ + 180.0f, p_115894_, p_319950_);
        p_115891_.rotateAround(p_320913_.getAttachFace().getOpposite().getRotation(), 0.0f, 0.5f, 0.0f);
    }
}

