/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;

public class PiglinRenderer
extends HumanoidMobRenderer<Mob, PiglinModel<Mob>> {
    private static final Map<EntityType<?>, ResourceLocation> TEXTURES = ImmutableMap.of(EntityType.PIGLIN, (Object)ResourceLocation.withDefaultNamespace("textures/entity/piglin/piglin.png"), EntityType.ZOMBIFIED_PIGLIN, (Object)ResourceLocation.withDefaultNamespace("textures/entity/piglin/zombified_piglin.png"), EntityType.PIGLIN_BRUTE, (Object)ResourceLocation.withDefaultNamespace("textures/entity/piglin/piglin_brute.png"));
    private static final float PIGLIN_CUSTOM_HEAD_SCALE = 1.0019531f;

    public PiglinRenderer(EntityRendererProvider.Context p_174344_, ModelLayerLocation p_174345_, ModelLayerLocation p_174346_, ModelLayerLocation p_174347_, boolean p_174348_) {
        super(p_174344_, PiglinRenderer.createModel(p_174344_.getModelSet(), p_174345_, p_174348_), 0.5f, 1.0019531f, 1.0f, 1.0019531f);
        this.addLayer(new HumanoidArmorLayer(this, new HumanoidArmorModel(p_174344_.bakeLayer(p_174346_)), new HumanoidArmorModel(p_174344_.bakeLayer(p_174347_)), p_174344_.getModelManager()));
    }

    private static PiglinModel<Mob> createModel(EntityModelSet p_174350_, ModelLayerLocation p_174351_, boolean p_174352_) {
        PiglinModel<Mob> $$3 = new PiglinModel<Mob>(p_174350_.bakeLayer(p_174351_));
        if (p_174352_) {
            $$3.rightEar.visible = false;
        }
        return $$3;
    }

    @Override
    public ResourceLocation getTextureLocation(Mob p_115708_) {
        ResourceLocation $$1 = TEXTURES.get(p_115708_.getType());
        if ($$1 == null) {
            throw new IllegalArgumentException("I don't know what texture to use for " + String.valueOf(p_115708_.getType()));
        }
        return $$1;
    }

    @Override
    protected boolean isShaking(Mob p_115712_) {
        return super.isShaking(p_115712_) || p_115712_ instanceof AbstractPiglin && ((AbstractPiglin)p_115712_).isConverting();
    }

    @Override
    protected /* synthetic */ boolean isShaking(LivingEntity livingEntity) {
        return this.isShaking((Mob)livingEntity);
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(Entity entity) {
        return this.getTextureLocation((Mob)entity);
    }
}

