/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;

public class PistonHeadRenderer
implements BlockEntityRenderer<PistonMovingBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public PistonHeadRenderer(BlockEntityRendererProvider.Context p_173623_) {
        this.blockRenderer = p_173623_.getBlockRenderDispatcher();
    }

    @Override
    public void render(PistonMovingBlockEntity p_112452_, float p_112453_, PoseStack p_112454_, MultiBufferSource p_112455_, int p_112456_, int p_112457_) {
        Level $$6 = p_112452_.getLevel();
        if ($$6 == null) {
            return;
        }
        BlockPos $$7 = p_112452_.getBlockPos().relative(p_112452_.getMovementDirection().getOpposite());
        BlockState $$8 = p_112452_.getMovedState();
        if ($$8.isAir()) {
            return;
        }
        ModelBlockRenderer.enableCaching();
        p_112454_.pushPose();
        p_112454_.translate(p_112452_.getXOff(p_112453_), p_112452_.getYOff(p_112453_), p_112452_.getZOff(p_112453_));
        if ($$8.is(Blocks.PISTON_HEAD) && p_112452_.getProgress(p_112453_) <= 4.0f) {
            $$8 = (BlockState)$$8.setValue(PistonHeadBlock.SHORT, p_112452_.getProgress(p_112453_) <= 0.5f);
            this.renderBlock($$7, $$8, p_112454_, p_112455_, $$6, false, p_112457_);
        } else if (p_112452_.isSourcePiston() && !p_112452_.isExtending()) {
            PistonType $$9 = $$8.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState $$10 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.TYPE, $$9)).setValue(PistonHeadBlock.FACING, $$8.getValue(PistonBaseBlock.FACING));
            $$10 = (BlockState)$$10.setValue(PistonHeadBlock.SHORT, p_112452_.getProgress(p_112453_) >= 0.5f);
            this.renderBlock($$7, $$10, p_112454_, p_112455_, $$6, false, p_112457_);
            BlockPos $$11 = $$7.relative(p_112452_.getMovementDirection());
            p_112454_.popPose();
            p_112454_.pushPose();
            $$8 = (BlockState)$$8.setValue(PistonBaseBlock.EXTENDED, true);
            this.renderBlock($$11, $$8, p_112454_, p_112455_, $$6, true, p_112457_);
        } else {
            this.renderBlock($$7, $$8, p_112454_, p_112455_, $$6, false, p_112457_);
        }
        p_112454_.popPose();
        ModelBlockRenderer.clearCache();
    }

    private void renderBlock(BlockPos p_112459_, BlockState p_112460_, PoseStack p_112461_, MultiBufferSource p_112462_, Level p_112463_, boolean p_112464_, int p_112465_) {
        RenderType $$7 = ItemBlockRenderTypes.getMovingBlockRenderType(p_112460_);
        VertexConsumer $$8 = p_112462_.getBuffer($$7);
        this.blockRenderer.getModelRenderer().tesselateBlock(p_112463_, this.blockRenderer.getBlockModel(p_112460_), p_112460_, p_112459_, p_112461_, $$8, p_112464_, RandomSource.create(), p_112460_.getSeed(p_112459_), p_112465_);
    }

    @Override
    public int getViewDistance() {
        return 68;
    }
}

