/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;

public class BlockFaceUV {
    public float[] uvs;
    public final int rotation;

    public BlockFaceUV(@Nullable float[] p_111390_, int p_111391_) {
        this.uvs = p_111390_;
        this.rotation = p_111391_;
    }

    public float getU(int p_111393_) {
        if (this.uvs == null) {
            throw new NullPointerException("uvs");
        }
        int $$1 = this.getShiftedIndex(p_111393_);
        return this.uvs[$$1 == 0 || $$1 == 1 ? 0 : 2];
    }

    public float getV(int p_111397_) {
        if (this.uvs == null) {
            throw new NullPointerException("uvs");
        }
        int $$1 = this.getShiftedIndex(p_111397_);
        return this.uvs[$$1 == 0 || $$1 == 3 ? 1 : 3];
    }

    private int getShiftedIndex(int p_111401_) {
        return (p_111401_ + this.rotation / 90) % 4;
    }

    public int getReverseIndex(int p_111399_) {
        return (p_111399_ + 4 - this.rotation / 90) % 4;
    }

    public void setMissingUv(float[] p_111395_) {
        if (this.uvs == null) {
            this.uvs = p_111395_;
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<BlockFaceUV> {
        private static final int DEFAULT_ROTATION = 0;

        protected Deserializer() {
        }

        public BlockFaceUV deserialize(JsonElement p_111404_, Type p_111405_, JsonDeserializationContext p_111406_) throws JsonParseException {
            JsonObject $$3 = p_111404_.getAsJsonObject();
            float[] $$4 = this.getUVs($$3);
            int $$5 = this.getRotation($$3);
            return new BlockFaceUV($$4, $$5);
        }

        protected int getRotation(JsonObject p_111408_) {
            int $$1 = GsonHelper.getAsInt(p_111408_, "rotation", 0);
            if ($$1 < 0 || $$1 % 90 != 0 || $$1 / 90 > 3) {
                throw new JsonParseException("Invalid rotation " + $$1 + " found, only 0/90/180/270 allowed");
            }
            return $$1;
        }

        @Nullable
        private float[] getUVs(JsonObject p_111410_) {
            if (!p_111410_.has("uv")) {
                return null;
            }
            JsonArray $$1 = GsonHelper.getAsJsonArray(p_111410_, "uv");
            if ($$1.size() != 4) {
                throw new JsonParseException("Expected 4 uv values, found: " + $$1.size());
            }
            float[] $$2 = new float[4];
            for (int $$3 = 0; $$3 < $$2.length; ++$$3) {
                $$2[$$3] = GsonHelper.convertToFloat($$1.get($$3), "uv[" + $$3 + "]");
            }
            return $$2;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

