/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;

public class ItemInHandRenderer {
    private static final RenderType MAP_BACKGROUND = RenderType.text(ResourceLocation.withDefaultNamespace("textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderType.text(ResourceLocation.withDefaultNamespace("textures/map/map_background_checkerboard.png"));
    private static final float ITEM_SWING_X_POS_SCALE = -0.4f;
    private static final float ITEM_SWING_Y_POS_SCALE = 0.2f;
    private static final float ITEM_SWING_Z_POS_SCALE = -0.2f;
    private static final float ITEM_HEIGHT_SCALE = -0.6f;
    private static final float ITEM_POS_X = 0.56f;
    private static final float ITEM_POS_Y = -0.52f;
    private static final float ITEM_POS_Z = -0.72f;
    private static final float ITEM_PRESWING_ROT_Y = 45.0f;
    private static final float ITEM_SWING_X_ROT_AMOUNT = -80.0f;
    private static final float ITEM_SWING_Y_ROT_AMOUNT = -20.0f;
    private static final float ITEM_SWING_Z_ROT_AMOUNT = -20.0f;
    private static final float EAT_JIGGLE_X_ROT_AMOUNT = 10.0f;
    private static final float EAT_JIGGLE_Y_ROT_AMOUNT = 90.0f;
    private static final float EAT_JIGGLE_Z_ROT_AMOUNT = 30.0f;
    private static final float EAT_JIGGLE_X_POS_SCALE = 0.6f;
    private static final float EAT_JIGGLE_Y_POS_SCALE = -0.5f;
    private static final float EAT_JIGGLE_Z_POS_SCALE = 0.0f;
    private static final double EAT_JIGGLE_EXPONENT = 27.0;
    private static final float EAT_EXTRA_JIGGLE_CUTOFF = 0.8f;
    private static final float EAT_EXTRA_JIGGLE_SCALE = 0.1f;
    private static final float ARM_SWING_X_POS_SCALE = -0.3f;
    private static final float ARM_SWING_Y_POS_SCALE = 0.4f;
    private static final float ARM_SWING_Z_POS_SCALE = -0.4f;
    private static final float ARM_SWING_Y_ROT_AMOUNT = 70.0f;
    private static final float ARM_SWING_Z_ROT_AMOUNT = -20.0f;
    private static final float ARM_HEIGHT_SCALE = -0.6f;
    private static final float ARM_POS_SCALE = 0.8f;
    private static final float ARM_POS_X = 0.8f;
    private static final float ARM_POS_Y = -0.75f;
    private static final float ARM_POS_Z = -0.9f;
    private static final float ARM_PRESWING_ROT_Y = 45.0f;
    private static final float ARM_PREROTATION_X_OFFSET = -1.0f;
    private static final float ARM_PREROTATION_Y_OFFSET = 3.6f;
    private static final float ARM_PREROTATION_Z_OFFSET = 3.5f;
    private static final float ARM_POSTROTATION_X_OFFSET = 5.6f;
    private static final int ARM_ROT_X = 200;
    private static final int ARM_ROT_Y = -135;
    private static final int ARM_ROT_Z = 120;
    private static final float MAP_SWING_X_POS_SCALE = -0.4f;
    private static final float MAP_SWING_Z_POS_SCALE = -0.2f;
    private static final float MAP_HANDS_POS_X = 0.0f;
    private static final float MAP_HANDS_POS_Y = 0.04f;
    private static final float MAP_HANDS_POS_Z = -0.72f;
    private static final float MAP_HANDS_HEIGHT_SCALE = -1.2f;
    private static final float MAP_HANDS_TILT_SCALE = -0.5f;
    private static final float MAP_PLAYER_PITCH_SCALE = 45.0f;
    private static final float MAP_HANDS_Z_ROT_AMOUNT = -85.0f;
    private static final float MAPHAND_X_ROT_AMOUNT = 45.0f;
    private static final float MAPHAND_Y_ROT_AMOUNT = 92.0f;
    private static final float MAPHAND_Z_ROT_AMOUNT = -41.0f;
    private static final float MAP_HAND_X_POS = 0.3f;
    private static final float MAP_HAND_Y_POS = -1.1f;
    private static final float MAP_HAND_Z_POS = 0.45f;
    private static final float MAP_SWING_X_ROT_AMOUNT = 20.0f;
    private static final float MAP_PRE_ROT_SCALE = 0.38f;
    private static final float MAP_GLOBAL_X_POS = -0.5f;
    private static final float MAP_GLOBAL_Y_POS = -0.5f;
    private static final float MAP_GLOBAL_Z_POS = 0.0f;
    private static final float MAP_FINAL_SCALE = 0.0078125f;
    private static final int MAP_BORDER = 7;
    private static final int MAP_HEIGHT = 128;
    private static final int MAP_WIDTH = 128;
    private static final float BOW_CHARGE_X_POS_SCALE = 0.0f;
    private static final float BOW_CHARGE_Y_POS_SCALE = 0.0f;
    private static final float BOW_CHARGE_Z_POS_SCALE = 0.04f;
    private static final float BOW_CHARGE_SHAKE_X_SCALE = 0.0f;
    private static final float BOW_CHARGE_SHAKE_Y_SCALE = 0.004f;
    private static final float BOW_CHARGE_SHAKE_Z_SCALE = 0.0f;
    private static final float BOW_CHARGE_Z_SCALE = 0.2f;
    private static final float BOW_MIN_SHAKE_CHARGE = 0.1f;
    private final Minecraft minecraft;
    private ItemStack mainHandItem = ItemStack.EMPTY;
    private ItemStack offHandItem = ItemStack.EMPTY;
    private float mainHandHeight;
    private float oMainHandHeight;
    private float offHandHeight;
    private float oOffHandHeight;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemRenderer itemRenderer;

    public ItemInHandRenderer(Minecraft p_234241_, EntityRenderDispatcher p_234242_, ItemRenderer p_234243_) {
        this.minecraft = p_234241_;
        this.entityRenderDispatcher = p_234242_;
        this.itemRenderer = p_234243_;
    }

    public void renderItem(LivingEntity p_270072_, ItemStack p_270793_, ItemDisplayContext p_270837_, boolean p_270203_, PoseStack p_270974_, MultiBufferSource p_270686_, int p_270103_) {
        if (p_270793_.isEmpty()) {
            return;
        }
        this.itemRenderer.renderStatic(p_270072_, p_270793_, p_270837_, p_270203_, p_270974_, p_270686_, p_270072_.level(), p_270103_, OverlayTexture.NO_OVERLAY, p_270072_.getId() + p_270837_.ordinal());
    }

    private float calculateMapTilt(float p_109313_) {
        float $$1 = 1.0f - p_109313_ / 45.0f + 0.1f;
        $$1 = Mth.clamp($$1, 0.0f, 1.0f);
        $$1 = -Mth.cos($$1 * (float)Math.PI) * 0.5f + 0.5f;
        return $$1;
    }

    private void renderMapHand(PoseStack p_109362_, MultiBufferSource p_109363_, int p_109364_, HumanoidArm p_109365_) {
        PlayerRenderer $$4 = (PlayerRenderer)this.entityRenderDispatcher.getRenderer(this.minecraft.player);
        p_109362_.pushPose();
        float $$5 = p_109365_ == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        p_109362_.mulPose(Axis.YP.rotationDegrees(92.0f));
        p_109362_.mulPose(Axis.XP.rotationDegrees(45.0f));
        p_109362_.mulPose(Axis.ZP.rotationDegrees($$5 * -41.0f));
        p_109362_.translate($$5 * 0.3f, -1.1f, 0.45f);
        if (p_109365_ == HumanoidArm.RIGHT) {
            $$4.renderRightHand(p_109362_, p_109363_, p_109364_, this.minecraft.player);
        } else {
            $$4.renderLeftHand(p_109362_, p_109363_, p_109364_, this.minecraft.player);
        }
        p_109362_.popPose();
    }

    private void renderOneHandedMap(PoseStack p_109354_, MultiBufferSource p_109355_, int p_109356_, float p_109357_, HumanoidArm p_109358_, float p_109359_, ItemStack p_109360_) {
        float $$7 = p_109358_ == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        p_109354_.translate($$7 * 0.125f, -0.125f, 0.0f);
        if (!this.minecraft.player.isInvisible()) {
            p_109354_.pushPose();
            p_109354_.mulPose(Axis.ZP.rotationDegrees($$7 * 10.0f));
            this.renderPlayerArm(p_109354_, p_109355_, p_109356_, p_109357_, p_109359_, p_109358_);
            p_109354_.popPose();
        }
        p_109354_.pushPose();
        p_109354_.translate($$7 * 0.51f, -0.08f + p_109357_ * -1.2f, -0.75f);
        float $$8 = Mth.sqrt(p_109359_);
        float $$9 = Mth.sin($$8 * (float)Math.PI);
        float $$10 = -0.5f * $$9;
        float $$11 = 0.4f * Mth.sin($$8 * ((float)Math.PI * 2));
        float $$12 = -0.3f * Mth.sin(p_109359_ * (float)Math.PI);
        p_109354_.translate($$7 * $$10, $$11 - 0.3f * $$9, $$12);
        p_109354_.mulPose(Axis.XP.rotationDegrees($$9 * -45.0f));
        p_109354_.mulPose(Axis.YP.rotationDegrees($$7 * $$9 * -30.0f));
        this.renderMap(p_109354_, p_109355_, p_109356_, p_109360_);
        p_109354_.popPose();
    }

    private void renderTwoHandedMap(PoseStack p_109340_, MultiBufferSource p_109341_, int p_109342_, float p_109343_, float p_109344_, float p_109345_) {
        float $$6 = Mth.sqrt(p_109345_);
        float $$7 = -0.2f * Mth.sin(p_109345_ * (float)Math.PI);
        float $$8 = -0.4f * Mth.sin($$6 * (float)Math.PI);
        p_109340_.translate(0.0f, -$$7 / 2.0f, $$8);
        float $$9 = this.calculateMapTilt(p_109343_);
        p_109340_.translate(0.0f, 0.04f + p_109344_ * -1.2f + $$9 * -0.5f, -0.72f);
        p_109340_.mulPose(Axis.XP.rotationDegrees($$9 * -85.0f));
        if (!this.minecraft.player.isInvisible()) {
            p_109340_.pushPose();
            p_109340_.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.renderMapHand(p_109340_, p_109341_, p_109342_, HumanoidArm.RIGHT);
            this.renderMapHand(p_109340_, p_109341_, p_109342_, HumanoidArm.LEFT);
            p_109340_.popPose();
        }
        float $$10 = Mth.sin($$6 * (float)Math.PI);
        p_109340_.mulPose(Axis.XP.rotationDegrees($$10 * 20.0f));
        p_109340_.scale(2.0f, 2.0f, 2.0f);
        this.renderMap(p_109340_, p_109341_, p_109342_, this.mainHandItem);
    }

    private void renderMap(PoseStack p_109367_, MultiBufferSource p_109368_, int p_109369_, ItemStack p_109370_) {
        p_109367_.mulPose(Axis.YP.rotationDegrees(180.0f));
        p_109367_.mulPose(Axis.ZP.rotationDegrees(180.0f));
        p_109367_.scale(0.38f, 0.38f, 0.38f);
        p_109367_.translate(-0.5f, -0.5f, 0.0f);
        p_109367_.scale(0.0078125f, 0.0078125f, 0.0078125f);
        MapId $$4 = p_109370_.get(DataComponents.MAP_ID);
        MapItemSavedData $$5 = MapItem.getSavedData($$4, (Level)this.minecraft.level);
        VertexConsumer $$6 = p_109368_.getBuffer($$5 == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD);
        Matrix4f $$7 = p_109367_.last().pose();
        $$6.addVertex($$7, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(p_109369_);
        $$6.addVertex($$7, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(p_109369_);
        $$6.addVertex($$7, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(p_109369_);
        $$6.addVertex($$7, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(p_109369_);
        if ($$5 != null) {
            this.minecraft.gameRenderer.getMapRenderer().render(p_109367_, p_109368_, $$4, $$5, false, p_109369_);
        }
    }

    private void renderPlayerArm(PoseStack p_109347_, MultiBufferSource p_109348_, int p_109349_, float p_109350_, float p_109351_, HumanoidArm p_109352_) {
        boolean $$6 = p_109352_ != HumanoidArm.LEFT;
        float $$7 = $$6 ? 1.0f : -1.0f;
        float $$8 = Mth.sqrt(p_109351_);
        float $$9 = -0.3f * Mth.sin($$8 * (float)Math.PI);
        float $$10 = 0.4f * Mth.sin($$8 * ((float)Math.PI * 2));
        float $$11 = -0.4f * Mth.sin(p_109351_ * (float)Math.PI);
        p_109347_.translate($$7 * ($$9 + 0.64000005f), $$10 + -0.6f + p_109350_ * -0.6f, $$11 + -0.71999997f);
        p_109347_.mulPose(Axis.YP.rotationDegrees($$7 * 45.0f));
        float $$12 = Mth.sin(p_109351_ * p_109351_ * (float)Math.PI);
        float $$13 = Mth.sin($$8 * (float)Math.PI);
        p_109347_.mulPose(Axis.YP.rotationDegrees($$7 * $$13 * 70.0f));
        p_109347_.mulPose(Axis.ZP.rotationDegrees($$7 * $$12 * -20.0f));
        LocalPlayer $$14 = this.minecraft.player;
        p_109347_.translate($$7 * -1.0f, 3.6f, 3.5f);
        p_109347_.mulPose(Axis.ZP.rotationDegrees($$7 * 120.0f));
        p_109347_.mulPose(Axis.XP.rotationDegrees(200.0f));
        p_109347_.mulPose(Axis.YP.rotationDegrees($$7 * -135.0f));
        p_109347_.translate($$7 * 5.6f, 0.0f, 0.0f);
        PlayerRenderer $$15 = (PlayerRenderer)this.entityRenderDispatcher.getRenderer($$14);
        if ($$6) {
            $$15.renderRightHand(p_109347_, p_109348_, p_109349_, $$14);
        } else {
            $$15.renderLeftHand(p_109347_, p_109348_, p_109349_, $$14);
        }
    }

    private void applyEatTransform(PoseStack p_109331_, float p_109332_, HumanoidArm p_109333_, ItemStack p_109334_, Player p_346361_) {
        float $$5 = (float)p_346361_.getUseItemRemainingTicks() - p_109332_ + 1.0f;
        float $$6 = $$5 / (float)p_109334_.getUseDuration(p_346361_);
        if ($$6 < 0.8f) {
            float $$7 = Mth.abs(Mth.cos($$5 / 4.0f * (float)Math.PI) * 0.1f);
            p_109331_.translate(0.0f, $$7, 0.0f);
        }
        float $$8 = 1.0f - (float)Math.pow($$6, 27.0);
        int $$9 = p_109333_ == HumanoidArm.RIGHT ? 1 : -1;
        p_109331_.translate($$8 * 0.6f * (float)$$9, $$8 * -0.5f, $$8 * 0.0f);
        p_109331_.mulPose(Axis.YP.rotationDegrees((float)$$9 * $$8 * 90.0f));
        p_109331_.mulPose(Axis.XP.rotationDegrees($$8 * 10.0f));
        p_109331_.mulPose(Axis.ZP.rotationDegrees((float)$$9 * $$8 * 30.0f));
    }

    private void applyBrushTransform(PoseStack p_273513_, float p_273245_, HumanoidArm p_273726_, ItemStack p_272809_, Player p_345294_, float p_273333_) {
        this.applyItemArmTransform(p_273513_, p_273726_, p_273333_);
        float $$6 = p_345294_.getUseItemRemainingTicks() % 10;
        float $$7 = $$6 - p_273245_ + 1.0f;
        float $$8 = 1.0f - $$7 / 10.0f;
        float $$9 = -90.0f;
        float $$10 = 60.0f;
        float $$11 = 150.0f;
        float $$12 = -15.0f;
        int $$13 = 2;
        float $$14 = -15.0f + 75.0f * Mth.cos($$8 * 2.0f * (float)Math.PI);
        if (p_273726_ != HumanoidArm.RIGHT) {
            p_273513_.translate(0.1, 0.83, 0.35);
            p_273513_.mulPose(Axis.XP.rotationDegrees(-80.0f));
            p_273513_.mulPose(Axis.YP.rotationDegrees(-90.0f));
            p_273513_.mulPose(Axis.XP.rotationDegrees($$14));
            p_273513_.translate(-0.3, 0.22, 0.35);
        } else {
            p_273513_.translate(-0.25, 0.22, 0.35);
            p_273513_.mulPose(Axis.XP.rotationDegrees(-80.0f));
            p_273513_.mulPose(Axis.YP.rotationDegrees(90.0f));
            p_273513_.mulPose(Axis.ZP.rotationDegrees(0.0f));
            p_273513_.mulPose(Axis.XP.rotationDegrees($$14));
        }
    }

    private void applyItemArmAttackTransform(PoseStack p_109336_, HumanoidArm p_109337_, float p_109338_) {
        int $$3 = p_109337_ == HumanoidArm.RIGHT ? 1 : -1;
        float $$4 = Mth.sin(p_109338_ * p_109338_ * (float)Math.PI);
        p_109336_.mulPose(Axis.YP.rotationDegrees((float)$$3 * (45.0f + $$4 * -20.0f)));
        float $$5 = Mth.sin(Mth.sqrt(p_109338_) * (float)Math.PI);
        p_109336_.mulPose(Axis.ZP.rotationDegrees((float)$$3 * $$5 * -20.0f));
        p_109336_.mulPose(Axis.XP.rotationDegrees($$5 * -80.0f));
        p_109336_.mulPose(Axis.YP.rotationDegrees((float)$$3 * -45.0f));
    }

    private void applyItemArmTransform(PoseStack p_109383_, HumanoidArm p_109384_, float p_109385_) {
        int $$3 = p_109384_ == HumanoidArm.RIGHT ? 1 : -1;
        p_109383_.translate((float)$$3 * 0.56f, -0.52f + p_109385_ * -0.6f, -0.72f);
    }

    public void renderHandsWithItems(float p_109315_, PoseStack p_109316_, MultiBufferSource.BufferSource p_109317_, LocalPlayer p_109318_, int p_109319_) {
        float $$5 = p_109318_.getAttackAnim(p_109315_);
        InteractionHand $$6 = (InteractionHand)((Object)MoreObjects.firstNonNull((Object)((Object)p_109318_.swingingArm), (Object)((Object)InteractionHand.MAIN_HAND)));
        float $$7 = Mth.lerp(p_109315_, p_109318_.xRotO, p_109318_.getXRot());
        HandRenderSelection $$8 = ItemInHandRenderer.evaluateWhichHandsToRender(p_109318_);
        float $$9 = Mth.lerp(p_109315_, p_109318_.xBobO, p_109318_.xBob);
        float $$10 = Mth.lerp(p_109315_, p_109318_.yBobO, p_109318_.yBob);
        p_109316_.mulPose(Axis.XP.rotationDegrees((p_109318_.getViewXRot(p_109315_) - $$9) * 0.1f));
        p_109316_.mulPose(Axis.YP.rotationDegrees((p_109318_.getViewYRot(p_109315_) - $$10) * 0.1f));
        if ($$8.renderMainHand) {
            float $$11 = $$6 == InteractionHand.MAIN_HAND ? $$5 : 0.0f;
            float $$12 = 1.0f - Mth.lerp(p_109315_, this.oMainHandHeight, this.mainHandHeight);
            this.renderArmWithItem(p_109318_, p_109315_, $$7, InteractionHand.MAIN_HAND, $$11, this.mainHandItem, $$12, p_109316_, p_109317_, p_109319_);
        }
        if ($$8.renderOffHand) {
            float $$13 = $$6 == InteractionHand.OFF_HAND ? $$5 : 0.0f;
            float $$14 = 1.0f - Mth.lerp(p_109315_, this.oOffHandHeight, this.offHandHeight);
            this.renderArmWithItem(p_109318_, p_109315_, $$7, InteractionHand.OFF_HAND, $$13, this.offHandItem, $$14, p_109316_, p_109317_, p_109319_);
        }
        p_109317_.endBatch();
    }

    @VisibleForTesting
    static HandRenderSelection evaluateWhichHandsToRender(LocalPlayer p_172915_) {
        boolean $$4;
        ItemStack $$1 = p_172915_.getMainHandItem();
        ItemStack $$2 = p_172915_.getOffhandItem();
        boolean $$3 = $$1.is(Items.BOW) || $$2.is(Items.BOW);
        boolean bl = $$4 = $$1.is(Items.CROSSBOW) || $$2.is(Items.CROSSBOW);
        if (!$$3 && !$$4) {
            return HandRenderSelection.RENDER_BOTH_HANDS;
        }
        if (p_172915_.isUsingItem()) {
            return ItemInHandRenderer.selectionUsingItemWhileHoldingBowLike(p_172915_);
        }
        if (ItemInHandRenderer.isChargedCrossbow($$1)) {
            return HandRenderSelection.RENDER_MAIN_HAND_ONLY;
        }
        return HandRenderSelection.RENDER_BOTH_HANDS;
    }

    private static HandRenderSelection selectionUsingItemWhileHoldingBowLike(LocalPlayer p_172917_) {
        ItemStack $$1 = p_172917_.getUseItem();
        InteractionHand $$2 = p_172917_.getUsedItemHand();
        if ($$1.is(Items.BOW) || $$1.is(Items.CROSSBOW)) {
            return HandRenderSelection.onlyForHand($$2);
        }
        return $$2 == InteractionHand.MAIN_HAND && ItemInHandRenderer.isChargedCrossbow(p_172917_.getOffhandItem()) ? HandRenderSelection.RENDER_MAIN_HAND_ONLY : HandRenderSelection.RENDER_BOTH_HANDS;
    }

    private static boolean isChargedCrossbow(ItemStack p_172913_) {
        return p_172913_.is(Items.CROSSBOW) && CrossbowItem.isCharged(p_172913_);
    }

    private void renderArmWithItem(AbstractClientPlayer p_109372_, float p_109373_, float p_109374_, InteractionHand p_109375_, float p_109376_, ItemStack p_109377_, float p_109378_, PoseStack p_109379_, MultiBufferSource p_109380_, int p_109381_) {
        if (p_109372_.isScoping()) {
            return;
        }
        boolean $$10 = p_109375_ == InteractionHand.MAIN_HAND;
        HumanoidArm $$11 = $$10 ? p_109372_.getMainArm() : p_109372_.getMainArm().getOpposite();
        p_109379_.pushPose();
        if (p_109377_.isEmpty()) {
            if ($$10 && !p_109372_.isInvisible()) {
                this.renderPlayerArm(p_109379_, p_109380_, p_109381_, p_109378_, p_109376_, $$11);
            }
        } else if (p_109377_.is(Items.FILLED_MAP)) {
            if ($$10 && this.offHandItem.isEmpty()) {
                this.renderTwoHandedMap(p_109379_, p_109380_, p_109381_, p_109374_, p_109378_, p_109376_);
            } else {
                this.renderOneHandedMap(p_109379_, p_109380_, p_109381_, p_109378_, $$11, p_109376_, p_109377_);
            }
        } else if (p_109377_.is(Items.CROSSBOW)) {
            int $$14;
            boolean $$12 = CrossbowItem.isCharged(p_109377_);
            boolean $$13 = $$11 == HumanoidArm.RIGHT;
            int n = $$14 = $$13 ? 1 : -1;
            if (p_109372_.isUsingItem() && p_109372_.getUseItemRemainingTicks() > 0 && p_109372_.getUsedItemHand() == p_109375_) {
                this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                p_109379_.translate((float)$$14 * -0.4785682f, -0.094387f, 0.05731531f);
                p_109379_.mulPose(Axis.XP.rotationDegrees(-11.935f));
                p_109379_.mulPose(Axis.YP.rotationDegrees((float)$$14 * 65.3f));
                p_109379_.mulPose(Axis.ZP.rotationDegrees((float)$$14 * -9.785f));
                float $$15 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                float $$16 = $$15 / (float)CrossbowItem.getChargeDuration(p_109377_, p_109372_);
                if ($$16 > 1.0f) {
                    $$16 = 1.0f;
                }
                if ($$16 > 0.1f) {
                    float $$17 = Mth.sin(($$15 - 0.1f) * 1.3f);
                    float $$18 = $$16 - 0.1f;
                    float $$19 = $$17 * $$18;
                    p_109379_.translate($$19 * 0.0f, $$19 * 0.004f, $$19 * 0.0f);
                }
                p_109379_.translate($$16 * 0.0f, $$16 * 0.0f, $$16 * 0.04f);
                p_109379_.scale(1.0f, 1.0f, 1.0f + $$16 * 0.2f);
                p_109379_.mulPose(Axis.YN.rotationDegrees((float)$$14 * 45.0f));
            } else {
                float $$20 = -0.4f * Mth.sin(Mth.sqrt(p_109376_) * (float)Math.PI);
                float $$21 = 0.2f * Mth.sin(Mth.sqrt(p_109376_) * ((float)Math.PI * 2));
                float $$22 = -0.2f * Mth.sin(p_109376_ * (float)Math.PI);
                p_109379_.translate((float)$$14 * $$20, $$21, $$22);
                this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                this.applyItemArmAttackTransform(p_109379_, $$11, p_109376_);
                if ($$12 && p_109376_ < 0.001f && $$10) {
                    p_109379_.translate((float)$$14 * -0.641864f, 0.0f, 0.0f);
                    p_109379_.mulPose(Axis.YP.rotationDegrees((float)$$14 * 10.0f));
                }
            }
            this.renderItem(p_109372_, p_109377_, $$13 ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !$$13, p_109379_, p_109380_, p_109381_);
        } else {
            boolean $$23;
            boolean bl = $$23 = $$11 == HumanoidArm.RIGHT;
            if (p_109372_.isUsingItem() && p_109372_.getUseItemRemainingTicks() > 0 && p_109372_.getUsedItemHand() == p_109375_) {
                int $$24 = $$23 ? 1 : -1;
                switch (p_109377_.getUseAnimation()) {
                    case NONE: {
                        this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.applyEatTransform(p_109379_, p_109373_, $$11, p_109377_, p_109372_);
                        this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                        break;
                    }
                    case BLOCK: {
                        this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                        break;
                    }
                    case BOW: {
                        this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                        p_109379_.translate((float)$$24 * -0.2785682f, 0.18344387f, 0.15731531f);
                        p_109379_.mulPose(Axis.XP.rotationDegrees(-13.935f));
                        p_109379_.mulPose(Axis.YP.rotationDegrees((float)$$24 * 35.3f));
                        p_109379_.mulPose(Axis.ZP.rotationDegrees((float)$$24 * -9.785f));
                        float $$25 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                        float $$26 = $$25 / 20.0f;
                        $$26 = ($$26 * $$26 + $$26 * 2.0f) / 3.0f;
                        if ($$26 > 1.0f) {
                            $$26 = 1.0f;
                        }
                        if ($$26 > 0.1f) {
                            float $$27 = Mth.sin(($$25 - 0.1f) * 1.3f);
                            float $$28 = $$26 - 0.1f;
                            float $$29 = $$27 * $$28;
                            p_109379_.translate($$29 * 0.0f, $$29 * 0.004f, $$29 * 0.0f);
                        }
                        p_109379_.translate($$26 * 0.0f, $$26 * 0.0f, $$26 * 0.04f);
                        p_109379_.scale(1.0f, 1.0f, 1.0f + $$26 * 0.2f);
                        p_109379_.mulPose(Axis.YN.rotationDegrees((float)$$24 * 45.0f));
                        break;
                    }
                    case SPEAR: {
                        this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                        p_109379_.translate((float)$$24 * -0.5f, 0.7f, 0.1f);
                        p_109379_.mulPose(Axis.XP.rotationDegrees(-55.0f));
                        p_109379_.mulPose(Axis.YP.rotationDegrees((float)$$24 * 35.3f));
                        p_109379_.mulPose(Axis.ZP.rotationDegrees((float)$$24 * -9.785f));
                        float $$30 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                        float $$31 = $$30 / 10.0f;
                        if ($$31 > 1.0f) {
                            $$31 = 1.0f;
                        }
                        if ($$31 > 0.1f) {
                            float $$32 = Mth.sin(($$30 - 0.1f) * 1.3f);
                            float $$33 = $$31 - 0.1f;
                            float $$34 = $$32 * $$33;
                            p_109379_.translate($$34 * 0.0f, $$34 * 0.004f, $$34 * 0.0f);
                        }
                        p_109379_.translate(0.0f, 0.0f, $$31 * 0.2f);
                        p_109379_.scale(1.0f, 1.0f, 1.0f + $$31 * 0.2f);
                        p_109379_.mulPose(Axis.YN.rotationDegrees((float)$$24 * 45.0f));
                        break;
                    }
                    case BRUSH: {
                        this.applyBrushTransform(p_109379_, p_109373_, $$11, p_109377_, p_109372_, p_109378_);
                    }
                }
            } else if (p_109372_.isAutoSpinAttack()) {
                this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                int $$35 = $$23 ? 1 : -1;
                p_109379_.translate((float)$$35 * -0.4f, 0.8f, 0.3f);
                p_109379_.mulPose(Axis.YP.rotationDegrees((float)$$35 * 65.0f));
                p_109379_.mulPose(Axis.ZP.rotationDegrees((float)$$35 * -85.0f));
            } else {
                float $$36 = -0.4f * Mth.sin(Mth.sqrt(p_109376_) * (float)Math.PI);
                float $$37 = 0.2f * Mth.sin(Mth.sqrt(p_109376_) * ((float)Math.PI * 2));
                float $$38 = -0.2f * Mth.sin(p_109376_ * (float)Math.PI);
                int $$39 = $$23 ? 1 : -1;
                p_109379_.translate((float)$$39 * $$36, $$37, $$38);
                this.applyItemArmTransform(p_109379_, $$11, p_109378_);
                this.applyItemArmAttackTransform(p_109379_, $$11, p_109376_);
            }
            this.renderItem(p_109372_, p_109377_, $$23 ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !$$23, p_109379_, p_109380_, p_109381_);
        }
        p_109379_.popPose();
    }

    public void tick() {
        this.oMainHandHeight = this.mainHandHeight;
        this.oOffHandHeight = this.offHandHeight;
        LocalPlayer $$0 = this.minecraft.player;
        ItemStack $$1 = $$0.getMainHandItem();
        ItemStack $$2 = $$0.getOffhandItem();
        if (ItemStack.matches(this.mainHandItem, $$1)) {
            this.mainHandItem = $$1;
        }
        if (ItemStack.matches(this.offHandItem, $$2)) {
            this.offHandItem = $$2;
        }
        if ($$0.isHandsBusy()) {
            this.mainHandHeight = Mth.clamp(this.mainHandHeight - 0.4f, 0.0f, 1.0f);
            this.offHandHeight = Mth.clamp(this.offHandHeight - 0.4f, 0.0f, 1.0f);
        } else {
            float $$3 = $$0.getAttackStrengthScale(1.0f);
            this.mainHandHeight += Mth.clamp((this.mainHandItem == $$1 ? $$3 * $$3 * $$3 : 0.0f) - this.mainHandHeight, -0.4f, 0.4f);
            this.offHandHeight += Mth.clamp((float)(this.offHandItem == $$2 ? 1 : 0) - this.offHandHeight, -0.4f, 0.4f);
        }
        if (this.mainHandHeight < 0.1f) {
            this.mainHandItem = $$1;
        }
        if (this.offHandHeight < 0.1f) {
            this.offHandItem = $$2;
        }
    }

    public void itemUsed(InteractionHand p_109321_) {
        if (p_109321_ == InteractionHand.MAIN_HAND) {
            this.mainHandHeight = 0.0f;
        } else {
            this.offHandHeight = 0.0f;
        }
    }

    @VisibleForTesting
    static enum HandRenderSelection {
        RENDER_BOTH_HANDS(true, true),
        RENDER_MAIN_HAND_ONLY(true, false),
        RENDER_OFF_HAND_ONLY(false, true);

        final boolean renderMainHand;
        final boolean renderOffHand;

        private HandRenderSelection(boolean p_172928_, boolean p_172929_) {
            this.renderMainHand = p_172928_;
            this.renderOffHand = p_172929_;
        }

        public static HandRenderSelection onlyForHand(InteractionHand p_172932_) {
            return p_172932_ == InteractionHand.MAIN_HAND ? RENDER_MAIN_HAND_ONLY : RENDER_OFF_HAND_ONLY;
        }
    }
}

