/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.mojang.authlib.yggdrasil.request.AbuseReportRequest;
import com.mojang.realmsclient.dto.RealmsServer;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public record ReportEnvironment(String clientVersion, @Nullable Server server) {
    public static ReportEnvironment local() {
        return ReportEnvironment.create(null);
    }

    public static ReportEnvironment thirdParty(String p_238999_) {
        return ReportEnvironment.create(new Server.ThirdParty(p_238999_));
    }

    public static ReportEnvironment realm(RealmsServer p_239765_) {
        return ReportEnvironment.create(new Server.Realm(p_239765_));
    }

    public static ReportEnvironment create(@Nullable Server p_239956_) {
        return new ReportEnvironment(ReportEnvironment.getClientVersion(), p_239956_);
    }

    public AbuseReportRequest.ClientInfo clientInfo() {
        return new AbuseReportRequest.ClientInfo(this.clientVersion, Locale.getDefault().toLanguageTag());
    }

    @Nullable
    public AbuseReportRequest.ThirdPartyServerInfo thirdPartyServerInfo() {
        Server server = this.server;
        if (server instanceof Server.ThirdParty) {
            Server.ThirdParty $$0 = (Server.ThirdParty)server;
            return new AbuseReportRequest.ThirdPartyServerInfo($$0.ip);
        }
        return null;
    }

    @Nullable
    public AbuseReportRequest.RealmInfo realmInfo() {
        Server server = this.server;
        if (server instanceof Server.Realm) {
            Server.Realm $$0 = (Server.Realm)server;
            return new AbuseReportRequest.RealmInfo(String.valueOf($$0.realmId()), $$0.slotId());
        }
        return null;
    }

    private static String getClientVersion() {
        StringBuilder $$0 = new StringBuilder();
        $$0.append("1.21.1");
        if (Minecraft.checkModStatus().shouldReportAsModified()) {
            $$0.append(" (modded)");
        }
        return $$0.toString();
    }

    public static interface Server {

        public record Realm(long realmId, int slotId) implements Server
        {
            public Realm(RealmsServer p_239068_) {
                this(p_239068_.id, p_239068_.activeSlot);
            }
        }

        public record ThirdParty(String ip) implements Server
        {
        }
    }
}

