/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeBookComponent
implements PlaceRecipe<Ingredient>,
Renderable,
GuiEventListener,
NarratableEntry,
RecipeShownListener {
    public static final WidgetSprites RECIPE_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/button"), ResourceLocation.withDefaultNamespace("recipe_book/button_highlighted"));
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace("recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace("recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace("recipe_book/filter_disabled_highlighted"));
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/recipe_book.png");
    private static final Component SEARCH_HINT = Component.translatable("gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;
    private static final Component ONLY_CRAFTABLES_TOOLTIP = Component.translatable("gui.recipebook.toggleRecipes.craftable");
    private static final Component ALL_RECIPES_TOOLTIP = Component.translatable("gui.recipebook.toggleRecipes.all");
    private int xOffset;
    private int width;
    private int height;
    protected final GhostRecipe ghostRecipe = new GhostRecipe();
    private final List<RecipeBookTabButton> tabButtons = Lists.newArrayList();
    @Nullable
    private RecipeBookTabButton selectedTab;
    protected StateSwitchingButton filterButton;
    protected RecipeBookMenu<?, ?> menu;
    protected Minecraft minecraft;
    @Nullable
    private EditBox searchBox;
    private String lastSearch = "";
    private ClientRecipeBook book;
    private final RecipeBookPage recipeBookPage = new RecipeBookPage();
    private final StackedContents stackedContents = new StackedContents();
    private int timesInventoryChanged;
    private boolean ignoreTextInput;
    private boolean visible;
    private boolean widthTooNarrow;

    public void init(int p_100310_, int p_100311_, Minecraft p_100312_, boolean p_100313_, RecipeBookMenu<?, ?> p_100314_) {
        this.minecraft = p_100312_;
        this.width = p_100310_;
        this.height = p_100311_;
        this.menu = p_100314_;
        this.widthTooNarrow = p_100313_;
        p_100312_.player.containerMenu = p_100314_;
        this.book = p_100312_.player.getRecipeBook();
        this.timesInventoryChanged = p_100312_.player.getInventory().getTimesChanged();
        this.visible = this.isVisibleAccordingToBookData();
        if (this.visible) {
            this.initVisuals();
        }
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int $$0 = (this.width - 147) / 2 - this.xOffset;
        int $$1 = (this.height - 166) / 2;
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        String $$2 = this.searchBox != null ? this.searchBox.getValue() : "";
        this.searchBox = new EditBox(this.minecraft.font, $$0 + 25, $$1 + 13, 81, this.minecraft.font.lineHeight + 5, Component.translatable("itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setValue($$2);
        this.searchBox.setHint(SEARCH_HINT);
        this.recipeBookPage.init(this.minecraft, $$0, $$1);
        this.recipeBookPage.addListener(this);
        this.filterButton = new StateSwitchingButton($$0 + 110, $$1 + 12, 26, 16, this.book.isFiltering(this.menu));
        this.updateFilterButtonTooltip();
        this.initFilterButtonTextures();
        this.tabButtons.clear();
        for (RecipeBookCategories $$3 : RecipeBookCategories.getCategories(this.menu.getRecipeBookType())) {
            this.tabButtons.add(new RecipeBookTabButton($$3));
        }
        if (this.selectedTab != null) {
            this.selectedTab = this.tabButtons.stream().filter(p_100329_ -> p_100329_.getCategory().equals((Object)this.selectedTab.getCategory())).findFirst().orElse(null);
        }
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
        }
        this.selectedTab.setStateTriggered(true);
        this.updateCollections(false);
        this.updateTabs();
    }

    private void updateFilterButtonTooltip() {
        this.filterButton.setTooltip(this.filterButton.isStateTriggered() ? Tooltip.create(this.getRecipeFilterName()) : Tooltip.create(ALL_RECIPES_TOOLTIP));
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_BUTTON_SPRITES);
    }

    public int updateScreenPosition(int p_181402_, int p_181403_) {
        int $$3;
        if (this.isVisible() && !this.widthTooNarrow) {
            int $$2 = 177 + (p_181402_ - p_181403_ - 200) / 2;
        } else {
            $$3 = (p_181402_ - p_181403_) / 2;
        }
        return $$3;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    private boolean isVisibleAccordingToBookData() {
        return this.book.isOpen(this.menu.getRecipeBookType());
    }

    protected void setVisible(boolean p_100370_) {
        if (p_100370_) {
            this.initVisuals();
        }
        this.visible = p_100370_;
        this.book.setOpen(this.menu.getRecipeBookType(), p_100370_);
        if (!p_100370_) {
            this.recipeBookPage.setInvisible();
        }
        this.sendUpdateSettings();
    }

    public void slotClicked(@Nullable Slot p_100315_) {
        if (p_100315_ != null && p_100315_.index < this.menu.getSize()) {
            this.ghostRecipe.clear();
            if (this.isVisible()) {
                this.updateStackedContents();
            }
        }
    }

    private void updateCollections(boolean p_100383_) {
        ClientPacketListener $$4;
        List<RecipeCollection> $$1 = this.book.getCollection(this.selectedTab.getCategory());
        $$1.forEach(p_302149_ -> p_302149_.canCraft(this.stackedContents, this.menu.getGridWidth(), this.menu.getGridHeight(), this.book));
        ArrayList $$2 = Lists.newArrayList($$1);
        $$2.removeIf(p_100368_ -> !p_100368_.hasKnownRecipes());
        $$2.removeIf(p_100360_ -> !p_100360_.hasFitting());
        String $$3 = this.searchBox.getValue();
        if (!$$3.isEmpty() && ($$4 = this.minecraft.getConnection()) != null) {
            ObjectLinkedOpenHashSet $$5 = new ObjectLinkedOpenHashSet($$4.searchTrees().recipes().search($$3.toLowerCase(Locale.ROOT)));
            $$2.removeIf(arg_0 -> RecipeBookComponent.lambda$updateCollections$4((ObjectSet)$$5, arg_0));
        }
        if (this.book.isFiltering(this.menu)) {
            $$2.removeIf(p_100331_ -> !p_100331_.hasCraftable());
        }
        this.recipeBookPage.updateCollections($$2, p_100383_);
    }

    private void updateTabs() {
        int $$0 = (this.width - 147) / 2 - this.xOffset - 30;
        int $$1 = (this.height - 166) / 2 + 3;
        int $$2 = 27;
        int $$3 = 0;
        for (RecipeBookTabButton $$4 : this.tabButtons) {
            RecipeBookCategories $$5 = $$4.getCategory();
            if ($$5 == RecipeBookCategories.CRAFTING_SEARCH || $$5 == RecipeBookCategories.FURNACE_SEARCH) {
                $$4.visible = true;
                $$4.setPosition($$0, $$1 + 27 * $$3++);
                continue;
            }
            if (!$$4.updateVisibility(this.book)) continue;
            $$4.setPosition($$0, $$1 + 27 * $$3++);
            $$4.startAnimation(this.minecraft);
        }
    }

    public void tick() {
        boolean $$0 = this.isVisibleAccordingToBookData();
        if (this.isVisible() != $$0) {
            this.setVisible($$0);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.timesInventoryChanged != this.minecraft.player.getInventory().getTimesChanged()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.minecraft.player.getInventory().getTimesChanged();
        }
    }

    private void updateStackedContents() {
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        this.updateCollections(false);
    }

    @Override
    public void render(GuiGraphics p_283597_, int p_282668_, int p_283506_, float p_282813_) {
        if (!this.isVisible()) {
            return;
        }
        p_283597_.pose().pushPose();
        p_283597_.pose().translate(0.0f, 0.0f, 100.0f);
        int $$4 = (this.width - 147) / 2 - this.xOffset;
        int $$5 = (this.height - 166) / 2;
        p_283597_.blit(RECIPE_BOOK_LOCATION, $$4, $$5, 1, 1, 147, 166);
        this.searchBox.render(p_283597_, p_282668_, p_283506_, p_282813_);
        for (RecipeBookTabButton $$6 : this.tabButtons) {
            $$6.render(p_283597_, p_282668_, p_283506_, p_282813_);
        }
        this.filterButton.render(p_283597_, p_282668_, p_283506_, p_282813_);
        this.recipeBookPage.render(p_283597_, $$4, $$5, p_282668_, p_283506_, p_282813_);
        p_283597_.pose().popPose();
    }

    public void renderTooltip(GuiGraphics p_281740_, int p_281520_, int p_282050_, int p_282836_, int p_282758_) {
        if (!this.isVisible()) {
            return;
        }
        this.recipeBookPage.renderTooltip(p_281740_, p_282836_, p_282758_);
        this.renderGhostRecipeTooltip(p_281740_, p_281520_, p_282050_, p_282836_, p_282758_);
    }

    protected Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    private void renderGhostRecipeTooltip(GuiGraphics p_282776_, int p_282886_, int p_281571_, int p_282948_, int p_283050_) {
        ItemStack $$5 = null;
        for (int $$6 = 0; $$6 < this.ghostRecipe.size(); ++$$6) {
            GhostRecipe.GhostIngredient $$7 = this.ghostRecipe.get($$6);
            int $$8 = $$7.getX() + p_282886_;
            int $$9 = $$7.getY() + p_281571_;
            if (p_282948_ < $$8 || p_283050_ < $$9 || p_282948_ >= $$8 + 16 || p_283050_ >= $$9 + 16) continue;
            $$5 = $$7.getItem();
        }
        if ($$5 != null && this.minecraft.screen != null) {
            p_282776_.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem(this.minecraft, $$5), p_282948_, p_283050_);
        }
    }

    public void renderGhostRecipe(GuiGraphics p_283634_, int p_283327_, int p_282027_, boolean p_283495_, float p_283514_) {
        this.ghostRecipe.render(p_283634_, this.minecraft, p_283327_, p_282027_, p_283495_, p_283514_);
    }

    @Override
    public boolean mouseClicked(double p_100294_, double p_100295_, int p_100296_) {
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.recipeBookPage.mouseClicked(p_100294_, p_100295_, p_100296_, (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166)) {
            RecipeHolder<?> $$3 = this.recipeBookPage.getLastClickedRecipe();
            RecipeCollection $$4 = this.recipeBookPage.getLastClickedRecipeCollection();
            if ($$3 != null && $$4 != null) {
                if (!$$4.isCraftable($$3) && this.ghostRecipe.getRecipe() == $$3) {
                    return false;
                }
                this.ghostRecipe.clear();
                this.minecraft.gameMode.handlePlaceRecipe(this.minecraft.player.containerMenu.containerId, $$3, Screen.hasShiftDown());
                if (!this.isOffsetNextToMainGUI()) {
                    this.setVisible(false);
                }
            }
            return true;
        }
        if (this.searchBox.mouseClicked(p_100294_, p_100295_, p_100296_)) {
            this.searchBox.setFocused(true);
            return true;
        }
        this.searchBox.setFocused(false);
        if (this.filterButton.mouseClicked(p_100294_, p_100295_, p_100296_)) {
            boolean $$5 = this.toggleFiltering();
            this.filterButton.setStateTriggered($$5);
            this.updateFilterButtonTooltip();
            this.sendUpdateSettings();
            this.updateCollections(false);
            return true;
        }
        for (RecipeBookTabButton $$6 : this.tabButtons) {
            if (!$$6.mouseClicked(p_100294_, p_100295_, p_100296_)) continue;
            if (this.selectedTab != $$6) {
                if (this.selectedTab != null) {
                    this.selectedTab.setStateTriggered(false);
                }
                this.selectedTab = $$6;
                this.selectedTab.setStateTriggered(true);
                this.updateCollections(true);
            }
            return true;
        }
        return false;
    }

    private boolean toggleFiltering() {
        RecipeBookType $$0 = this.menu.getRecipeBookType();
        boolean $$1 = !this.book.isFiltering($$0);
        this.book.setFiltering($$0, $$1);
        return $$1;
    }

    public boolean hasClickedOutside(double p_100298_, double p_100299_, int p_100300_, int p_100301_, int p_100302_, int p_100303_, int p_100304_) {
        if (!this.isVisible()) {
            return true;
        }
        boolean $$7 = p_100298_ < (double)p_100300_ || p_100299_ < (double)p_100301_ || p_100298_ >= (double)(p_100300_ + p_100302_) || p_100299_ >= (double)(p_100301_ + p_100303_);
        boolean $$8 = (double)(p_100300_ - 147) < p_100298_ && p_100298_ < (double)p_100300_ && (double)p_100301_ < p_100299_ && p_100299_ < (double)(p_100301_ + p_100303_);
        return $$7 && !$$8 && !this.selectedTab.isHoveredOrFocused();
    }

    @Override
    public boolean keyPressed(int p_100306_, int p_100307_, int p_100308_) {
        this.ignoreTextInput = false;
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (p_100306_ == 256 && !this.isOffsetNextToMainGUI()) {
            this.setVisible(false);
            return true;
        }
        if (this.searchBox.keyPressed(p_100306_, p_100307_, p_100308_)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && p_100306_ != 256) {
            return true;
        }
        if (this.minecraft.options.keyChat.matches(p_100306_, p_100307_) && !this.searchBox.isFocused()) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int p_100356_, int p_100357_, int p_100358_) {
        this.ignoreTextInput = false;
        return GuiEventListener.super.keyReleased(p_100356_, p_100357_, p_100358_);
    }

    @Override
    public boolean charTyped(char p_100291_, int p_100292_) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.searchBox.charTyped(p_100291_, p_100292_)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return GuiEventListener.super.charTyped(p_100291_, p_100292_);
    }

    @Override
    public boolean isMouseOver(double p_100353_, double p_100354_) {
        return false;
    }

    @Override
    public void setFocused(boolean p_265089_) {
    }

    @Override
    public boolean isFocused() {
        return false;
    }

    private void checkSearchStringUpdate() {
        String $$0 = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        this.pirateSpeechForThePeople($$0);
        if (!$$0.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = $$0;
        }
    }

    private void pirateSpeechForThePeople(String p_100336_) {
        if ("excitedze".equals(p_100336_)) {
            LanguageManager $$1 = this.minecraft.getLanguageManager();
            String $$2 = "en_pt";
            LanguageInfo $$3 = $$1.getLanguage("en_pt");
            if ($$3 == null || $$1.getSelected().equals("en_pt")) {
                return;
            }
            $$1.setSelected("en_pt");
            this.minecraft.options.languageCode = "en_pt";
            this.minecraft.reloadResourcePacks();
            this.minecraft.options.save();
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    public void recipesUpdated() {
        this.updateTabs();
        if (this.isVisible()) {
            this.updateCollections(false);
        }
    }

    @Override
    public void recipesShown(List<RecipeHolder<?>> p_100344_) {
        for (RecipeHolder<?> $$1 : p_100344_) {
            this.minecraft.player.removeRecipeHighlight($$1);
        }
    }

    public void setupGhostRecipe(RecipeHolder<?> p_301197_, List<Slot> p_100317_) {
        ItemStack $$2 = p_301197_.value().getResultItem(this.minecraft.level.registryAccess());
        this.ghostRecipe.setRecipe(p_301197_);
        this.ghostRecipe.addIngredient(Ingredient.of($$2), p_100317_.get((int)0).x, p_100317_.get((int)0).y);
        this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), p_301197_, p_301197_.value().getIngredients().iterator(), 0);
    }

    @Override
    public void addItemToSlot(Ingredient p_345052_, int p_345781_, int p_345753_, int p_345694_, int p_345502_) {
        if (!p_345052_.isEmpty()) {
            Slot $$5 = (Slot)this.menu.slots.get(p_345781_);
            this.ghostRecipe.addIngredient(p_345052_, $$5.x, $$5.y);
        }
    }

    protected void sendUpdateSettings() {
        if (this.minecraft.getConnection() != null) {
            RecipeBookType $$0 = this.menu.getRecipeBookType();
            boolean $$1 = this.book.getBookSettings().isOpen($$0);
            boolean $$2 = this.book.getBookSettings().isFiltering($$0);
            this.minecraft.getConnection().send(new ServerboundRecipeBookChangeSettingsPacket($$0, $$1, $$2));
        }
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.visible ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Override
    public void updateNarration(NarrationElementOutput p_170046_) {
        ArrayList $$1 = Lists.newArrayList();
        this.recipeBookPage.listButtons(p_170049_ -> {
            if (p_170049_.isActive()) {
                $$1.add(p_170049_);
            }
        });
        $$1.add(this.searchBox);
        $$1.add(this.filterButton);
        $$1.addAll(this.tabButtons);
        Screen.NarratableSearchResult $$2 = Screen.findNarratableWidget($$1, null);
        if ($$2 != null) {
            $$2.entry.updateNarration(p_170046_.nest());
        }
    }

    private static /* synthetic */ boolean lambda$updateCollections$4(ObjectSet p_302147_, RecipeCollection p_302148_) {
        return !p_302147_.contains((Object)p_302148_);
    }
}

