/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import pro.gravit.launcher.dARKLAunchERxA;
import pro.gravit.launcher.dArkLAunchErlr;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.SecurityHelper$DigestAlgorithm;

public final class Texture
extends dArkLAunchErlr {
    private static final SecurityHelper$DigestAlgorithm DIGEST_ALGO = SecurityHelper$DigestAlgorithm.SHA256;
    public final String url;
    public final byte[] digest;
    public final Map<String, String> metadata;

    public Texture(String string, boolean bl, Map<String, String> map) {
        byte[] byArray;
        InputStream inputStream;
        this.url = IOHelper.verifyURL(string);
        try {
            inputStream = IOHelper.newInput(new URI(string).toURL());
            try {
                byArray = IOHelper.read(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        inputStream = new ByteArrayInputStream(byArray);
        try {
            IOHelper.readTexture(inputStream, bl);
        }
        finally {
            ((ByteArrayInputStream)inputStream).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, byArray);
        this.metadata = map;
    }

    public Texture(String string, Path path, boolean bl, Map<String, String> map) {
        byte[] byArray;
        this.url = IOHelper.verifyURL(string);
        try (InputStream inputStream = IOHelper.newInput(path);){
            byArray = IOHelper.read(inputStream);
        }
        inputStream = new ByteArrayInputStream(byArray);
        try {
            IOHelper.readTexture(inputStream, bl);
        }
        finally {
            ((ByteArrayInputStream)inputStream).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, byArray);
        this.metadata = map;
    }

    @Deprecated
    public Texture(String string, byte[] byArray) {
        this.url = IOHelper.verifyURL(string);
        this.digest = byArray == null ? new byte[]{} : byArray;
        this.metadata = null;
    }

    public Texture(String string, byte[] byArray, Map<String, String> map) {
        this.url = string;
        this.digest = byArray == null ? new byte[]{} : byArray;
        this.metadata = map;
    }

    @Override
    public void write(dARKLAunchERxA dARKLAunchERxA2) {
        dARKLAunchERxA2.daRKLAUNcheRjI(this.url, 2048);
        dARKLAunchERxA2.daRKLAUNcheRjI(this.digest, -Texture.DIGEST_ALGO.bytes);
    }

    public String toString() {
        return "Texture{url='" + this.url + "', digest=" + Arrays.toString(this.digest) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

