/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public class SolarisInternetProtocolStats
extends AbstractInternetProtocolStats {
    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        return SolarisInternetProtocolStats.getTcpStats();
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        return SolarisInternetProtocolStats.getUdpStats();
    }

    private static InternetProtocolStats.TcpStats getTcpStats() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        List<String> list = ExecutingCommand.runNative("netstat -s -P tcp");
        list.addAll(ExecutingCommand.runNative("netstat -s -P ip"));
        for (String string : list) {
            String[] stringArray;
            block25: for (String string2 : stringArray = SolarisInternetProtocolStats.splitOnPrefix(string, "tcp")) {
                String[] stringArray2;
                if (string2 == null || (stringArray2 = string2.split("=")).length != 2) continue;
                switch (stringArray2[0].trim()) {
                    case "tcpCurrEstab": {
                        l = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpActiveOpens": {
                        l2 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpPassiveOpens": {
                        l3 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpAttemptFails": {
                        l4 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpEstabResets": {
                        l5 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpOutSegs": {
                        l6 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpInSegs": {
                        l7 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpRetransSegs": {
                        l8 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpInErr": {
                        l9 = ParseUtil.getFirstIntValue(stringArray2[1].trim());
                        continue block25;
                    }
                    case "tcpOutRsts": {
                        l10 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block25;
                    }
                }
            }
        }
        return new InternetProtocolStats.TcpStats(l, l2, l3, l4, l5, l6, l7, l8, l9, l10);
    }

    private static InternetProtocolStats.UdpStats getUdpStats() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        List<String> list = ExecutingCommand.runNative("netstat -s -P udp");
        list.addAll(ExecutingCommand.runNative("netstat -s -P ip"));
        for (String string : list) {
            String[] stringArray;
            block13: for (String string2 : stringArray = SolarisInternetProtocolStats.splitOnPrefix(string, "udp")) {
                String[] stringArray2;
                if (string2 == null || (stringArray2 = string2.split("=")).length != 2) continue;
                switch (stringArray2[0].trim()) {
                    case "udpOutDatagrams": {
                        l = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpInDatagrams": {
                        l2 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpNoPorts": {
                        l3 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpInErrors": {
                        l4 = ParseUtil.parseLongOrDefault(stringArray2[1].trim(), 0L);
                        continue block13;
                    }
                }
            }
        }
        return new InternetProtocolStats.UdpStats(l, l2, l3, l4);
    }

    private static String[] splitOnPrefix(String string, String string2) {
        String[] stringArray = new String[2];
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = string.indexOf(string2, n + 1);
            if (n2 >= 0) {
                stringArray[0] = string.substring(n, n2).trim();
                stringArray[1] = string.substring(n2).trim();
            } else {
                stringArray[0] = string.substring(n).trim();
            }
        }
        return stringArray;
    }
}

